/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool.rdf;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.NumericLiteralImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.common.WikibasePoint;
import org.wikidata.query.rdf.common.uri.WikibaseUris;
import org.wikidata.query.rdf.tool.change.Change;
import org.wikidata.query.rdf.tool.exception.ContainedException;
import org.wikidata.query.rdf.tool.rdf.PointCoordinateSwitcher;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="spotbug limitation: https://github.com/spotbugs/spotbugs/issues/463")
public class Munger {
    private static final Logger log = LoggerFactory.getLogger(Munger.class);
    private final WikibaseUris uris;
    private final Set<String> limitLabelLanguages;
    private final List<String> singleLabelModeLanguages;
    private final boolean removeSiteLinks;
    private boolean keepTypes;
    private String dumpFormatVersion;
    private final Map<String, FormatHandler> formatHandlers;

    public Munger(WikibaseUris uris) {
        this(uris, null, null, false);
    }

    private Munger(WikibaseUris uris, Set<String> limitLabelLanguages, List<String> singleLabelModeLanguages, boolean removeSiteLinks) {
        this.uris = uris;
        this.limitLabelLanguages = limitLabelLanguages;
        this.singleLabelModeLanguages = singleLabelModeLanguages;
        this.removeSiteLinks = removeSiteLinks;
        this.formatHandlers = new HashMap<String, FormatHandler>();
        if (WikibasePoint.DEFAULT_ORDER == WikibasePoint.CoordinateOrder.LAT_LONG) {
            this.addFormatHandler("0.0.2", new PointCoordinateSwitcher());
        } else {
            this.addFormatHandler("0.0.1", new PointCoordinateSwitcher());
        }
    }

    public Munger keepTypes(boolean keep) {
        this.keepTypes = keep;
        return this;
    }

    public Munger limitLabelLanguages(String ... languages) {
        return this.limitLabelLanguages(Arrays.asList(languages));
    }

    public Munger limitLabelLanguages(Collection<String> languages) {
        return new Munger(this.uris, (Set<String>)ImmutableSet.copyOf(languages), this.singleLabelModeLanguages, this.removeSiteLinks);
    }

    public Munger singleLabelMode(String ... languages) {
        return this.singleLabelMode(Arrays.asList(languages));
    }

    public Munger singleLabelMode(Collection<String> languages) {
        return new Munger(this.uris, this.limitLabelLanguages, (List<String>)ImmutableList.copyOf(languages).reverse(), this.removeSiteLinks);
    }

    public Munger removeSiteLinks() {
        return new Munger(this.uris, this.limitLabelLanguages, this.singleLabelModeLanguages, true);
    }

    public void setFormatVersion(String version) {
        this.dumpFormatVersion = version;
    }

    public final void addFormatHandler(String version, FormatHandler handler) {
        this.formatHandlers.put(version, handler);
    }

    public void munge(String entityId, Collection<Statement> statements, Collection<String> existingValues, Collection<String> existingRefs, Change sourceChange) {
        if (statements.isEmpty()) {
            return;
        }
        MungeOperation op = new MungeOperation(entityId, statements, existingValues, existingRefs);
        if (sourceChange != null) {
            op.importFromChange(sourceChange);
        }
        op.munge();
        existingValues.removeAll(op.extraValidSubjects);
        existingRefs.removeAll(op.extraValidSubjects);
    }

    public void munge(String entityId, Collection<Statement> statements, Collection<String> existingValues, Collection<String> existingRefs) {
        this.munge(entityId, statements, existingValues, existingRefs, null);
    }

    public void munge(String entityId, Collection<Statement> statements) {
        this.munge(entityId, statements, Collections.EMPTY_SET, Collections.EMPTY_SET, null);
    }

    public static class BadSubjectException
    extends ContainedException {
        private static final long serialVersionUID = -4869053066714948939L;

        public BadSubjectException(Set<String> badSubjects, WikibaseUris uris) {
            super(String.format(Locale.ROOT, "Unrecognized subjects:  %s.  Expected only sitelinks and subjects starting with %s and %s", badSubjects, uris.entityData(), uris.entity()));
        }
    }

    private class MungeOperation {
        private final String entityUri;
        private final Collection<Statement> statements;
        private final Resource entityUriImpl;
        private final List<Statement> restoredStatements = new ArrayList<Statement>();
        private final Set<String> siteLinks = new HashSet<String>();
        private final Set<String> extraValidSubjects = new HashSet<String>();
        private final ListMultimap<String, Statement> unknownSubjects = ArrayListMultimap.create();
        private final SingleLabelModeWork singleLabelModeWorkForLabel;
        private final SingleLabelModeWork singleLabelModeWorkForDescription;
        private final Collection<String> existingValues;
        private final Collection<String> existingRefs;
        private final Set<Pair<URI, Literal>> dataStatements = new HashSet<Pair<URI, Literal>>();
        private Literal revisionId;
        private Literal lastModified;
        private Statement statement;
        private String subject;
        private String predicate;
        private FormatHandler formatHandler;

        MungeOperation(String entityId, Collection<Statement> statements, Collection<String> existingValues, Collection<String> existingRefs) {
            this.statements = statements;
            this.entityUri = Munger.this.uris.entity() + entityId;
            this.entityUriImpl = new URIImpl(this.entityUri);
            if (Munger.this.singleLabelModeLanguages != null) {
                this.singleLabelModeWorkForLabel = new SingleLabelModeWork();
                this.singleLabelModeWorkForDescription = new SingleLabelModeWork();
            } else {
                this.singleLabelModeWorkForLabel = null;
                this.singleLabelModeWorkForDescription = null;
            }
            this.existingValues = existingValues;
            this.existingRefs = existingRefs;
            this.setFormatVersion(Munger.this.dumpFormatVersion);
        }

        private void setFormatVersion(String version) {
            this.formatHandler = (FormatHandler)Munger.this.formatHandlers.get(version);
        }

        public void importFromChange(Change sourceChange) {
            if (sourceChange.revision() > 0L) {
                this.revisionId = new NumericLiteralImpl(sourceChange.revision());
            }
            if (sourceChange.timestamp() != null) {
                Date date = sourceChange.timestamp();
                Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ROOT);
                c.setTime(date);
                this.lastModified = new LiteralImpl(DatatypeConverter.printDate((Calendar)c), XMLSchema.DATETIME);
            }
        }

        public void munge() {
            Iterator<Statement> itr = this.statements.iterator();
            while (itr.hasNext()) {
                Statement shortStatement;
                this.statement = itr.next();
                if (this.formatHandler != null) {
                    Statement handled = this.formatHandler.handle(this.statement);
                    if (handled == null) {
                        itr.remove();
                        continue;
                    }
                    if (!handled.equals((Object)this.statement)) {
                        itr.remove();
                        this.statement = handled;
                        if (this.statement()) {
                            this.restoredStatements.add(this.statement);
                            continue;
                        }
                    }
                }
                if (!this.statement()) {
                    itr.remove();
                }
                if ((shortStatement = this.checkObjectLength()) == null) continue;
                itr.remove();
                this.restoredStatements.add(shortStatement);
            }
            this.statement = null;
            this.finishSingleLabelMode();
            this.finishCommon();
        }

        private Statement checkObjectLength() {
            Literal value;
            if (this.statement.getObject() instanceof Literal && (value = (Literal)this.statement.getObject()).stringValue().length() > Short.MAX_VALUE) {
                LiteralImpl newValue = value.getDatatype().equals((Object)RDF.LANGSTRING) ? new LiteralImpl(value.stringValue().substring(0, Short.MAX_VALUE), value.getLanguage()) : new LiteralImpl(value.stringValue().substring(0, Short.MAX_VALUE), value.getDatatype());
                return new StatementImpl(this.statement.getSubject(), this.statement.getPredicate(), (Value)newValue);
            }
            return null;
        }

        private boolean statement() {
            this.subject = this.statement.getSubject().stringValue();
            this.predicate = this.statement.getPredicate().stringValue();
            if (this.subject.equals("http://wikiba.se/ontology#Dump")) {
                return false;
            }
            if (this.inNamespace(this.subject, Munger.this.uris.entityData()) || this.inNamespace(this.subject, Munger.this.uris.entityDataHttps())) {
                return this.entityDataStatement();
            }
            if (this.inNamespace(this.subject, Munger.this.uris.statement())) {
                return this.entityStatementStatement();
            }
            if (this.inNamespace(this.subject, Munger.this.uris.reference())) {
                return this.entityReferenceStatement();
            }
            if (this.inNamespace(this.subject, Munger.this.uris.value())) {
                return this.entityValueStatement();
            }
            if (this.inNamespace(this.subject, Munger.this.uris.entity())) {
                return this.entityStatement();
            }
            if (this.subject.startsWith(Munger.this.uris.property(WikibaseUris.PropertyType.CLAIM))) {
                return this.propertyStatement();
            }
            if (this.statement.getSubject() instanceof BNode) {
                return true;
            }
            return this.unknownStatement();
        }

        private boolean inNamespace(String uri, String namespace) {
            return uri.startsWith(namespace) && uri.indexOf(47, namespace.length()) < 0;
        }

        private boolean propertyStatement() {
            if (this.subject.startsWith(Munger.this.uris.property(WikibaseUris.PropertyType.NOVALUE))) {
                return true;
            }
            return this.predicate.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        }

        private boolean entityDataStatement() {
            boolean knownPredicate = false;
            switch (this.predicate) {
                case "http://schema.org/version": {
                    knownPredicate = true;
                    this.revisionId = this.objectAsLiteral();
                    break;
                }
                case "http://schema.org/dateModified": {
                    knownPredicate = true;
                    this.lastModified = this.objectAsLiteral();
                    break;
                }
                case "http://schema.org/softwareVersion": {
                    this.setFormatVersion(this.objectAsLiteral().stringValue());
                    break;
                }
                default: {
                    if (!this.predicate.startsWith("http://wikiba.se/ontology#")) break;
                    knownPredicate = true;
                }
            }
            if (knownPredicate) {
                this.dataStatements.add((Pair<URI, Literal>)new ImmutablePair((Object)this.statement.getPredicate(), (Object)this.objectAsLiteral()));
            }
            return false;
        }

        private boolean entityStatement() {
            if (!this.subject.equals(this.entityUri)) {
                return false;
            }
            switch (this.predicate) {
                case "http://www.w3.org/1999/02/22-rdf-syntax-ns#type": {
                    if (Munger.this.keepTypes) {
                        return true;
                    }
                    return !this.statement.getObject().stringValue().equals("http://wikiba.se/ontology#Item");
                }
                case "http://schema.org/name": 
                case "http://www.w3.org/2004/02/skos/core#prefLabel": {
                    return false;
                }
                case "http://www.w3.org/2000/01/rdf-schema#label": {
                    return this.limitLabelLanguage() && this.singleLabelMode(this.singleLabelModeWorkForLabel);
                }
                case "http://schema.org/description": {
                    return this.limitLabelLanguage() && this.singleLabelMode(this.singleLabelModeWorkForDescription);
                }
                case "http://www.w3.org/2004/02/skos/core#altLabel": {
                    return this.limitLabelLanguage();
                }
                case "http://www.w3.org/2002/07/owl#sameAs": {
                    return true;
                }
            }
            return this.entityStatementWithUnrecognizedPredicate();
        }

        private boolean entityStatementWithUnrecognizedPredicate() {
            String object = this.statement.getObject().stringValue();
            if (this.inNamespace(this.predicate, Munger.this.uris.property(WikibaseUris.PropertyType.CLAIM)) && this.inNamespace(object, Munger.this.uris.statement())) {
                this.registerExtraValidSubject(object);
            }
            return true;
        }

        private boolean entityStatementStatement() {
            switch (this.predicate) {
                case "http://www.w3.org/1999/02/22-rdf-syntax-ns#type": {
                    if (Munger.this.keepTypes) {
                        return true;
                    }
                    if (!this.statement.getObject().stringValue().equals("http://wikiba.se/ontology#Statement")) break;
                    return false;
                }
                case "http://www.w3.org/ns/prov#wasDerivedFrom": {
                    String object = this.statement.getObject().stringValue();
                    if (this.inNamespace(object, Munger.this.uris.reference())) {
                        this.registerExtraValidSubject(object);
                    }
                    return true;
                }
            }
            if (!this.extraValidSubjects.contains(this.subject)) {
                this.unknownSubjects.put((Object)this.subject, (Object)this.statement);
                return false;
            }
            String object = this.statement.getObject().stringValue();
            if (this.inNamespace(object, Munger.this.uris.value())) {
                this.registerExtraValidSubject(object);
            }
            return true;
        }

        private boolean entityReferenceStatement() {
            if (this.existingRefs.contains(this.subject)) {
                return false;
            }
            switch (this.predicate) {
                case "http://www.w3.org/1999/02/22-rdf-syntax-ns#type": {
                    if (Munger.this.keepTypes) {
                        return true;
                    }
                    if (!this.statement.getObject().stringValue().equals("http://wikiba.se/ontology#Reference")) break;
                    return false;
                }
            }
            if (!this.extraValidSubjects.contains(this.subject)) {
                this.unknownSubjects.put((Object)this.subject, (Object)this.statement);
                return false;
            }
            String object = this.statement.getObject().stringValue();
            if (this.inNamespace(this.predicate, Munger.this.uris.property(WikibaseUris.PropertyType.REFERENCE_VALUE)) && this.inNamespace(object, Munger.this.uris.value())) {
                this.registerExtraValidSubject(object);
            }
            return true;
        }

        private boolean entityValueStatement() {
            if (this.existingValues.contains(this.subject)) {
                return false;
            }
            switch (this.predicate) {
                case "http://www.w3.org/1999/02/22-rdf-syntax-ns#type": {
                    if (Munger.this.keepTypes) {
                        return true;
                    }
                    if (!this.statement.getObject().stringValue().equals("http://wikiba.se/ontology#Value")) break;
                    return false;
                }
                case "http://wikiba.se/ontology#quantityNormalized": {
                    this.registerExtraValidSubject(this.statement.getObject().stringValue());
                    break;
                }
            }
            if (!this.extraValidSubjects.contains(this.subject)) {
                this.unknownSubjects.put((Object)this.subject, (Object)this.statement);
                return false;
            }
            return true;
        }

        private boolean unknownStatement() {
            if (this.predicate.equals("http://wikiba.se/ontology#wikiGroup")) {
                return true;
            }
            if (this.siteLinks.contains(this.subject)) {
                return !Munger.this.removeSiteLinks;
            }
            if (this.extraValidSubjects.contains(this.subject)) {
                return true;
            }
            if (this.predicate.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type") && this.statement.getObject().stringValue().equals("http://schema.org/Article")) {
                this.siteLinks.add(this.subject);
                if (Munger.this.removeSiteLinks) {
                    this.unknownSubjects.removeAll((Object)this.subject);
                    return false;
                }
                this.restoredStatements.addAll(this.unknownSubjects.removeAll((Object)this.subject));
                return true;
            }
            this.unknownSubjects.put((Object)this.subject, (Object)this.statement);
            return false;
        }

        private boolean limitLabelLanguage() {
            if (Munger.this.limitLabelLanguages == null) {
                return true;
            }
            Literal object = this.objectAsLiteral();
            String language = object.getLanguage();
            return language != null && Munger.this.limitLabelLanguages.contains(language);
        }

        private boolean singleLabelMode(SingleLabelModeWork work) {
            return work == null ? true : work.statement();
        }

        private void finishCommon() {
            if (!this.unknownSubjects.isEmpty()) {
                if (this.statements.isEmpty() && this.restoredStatements.isEmpty()) {
                    throw new BadSubjectException(this.unknownSubjects.keySet(), Munger.this.uris);
                }
                log.info("Unrecognized subjects: {} while processing {}.  Expected only sitelinks and subjects starting with {} and {}", new Object[]{this.unknownSubjects.keySet(), this.entityUri, Munger.this.uris.entityData(), Munger.this.uris.entity()});
            }
            if (this.revisionId == null) {
                throw new ContainedException("Didn't get a revision id for " + this.statements);
            }
            if (this.lastModified == null) {
                throw new ContainedException("Didn't get a last modified date for " + this.statements);
            }
            for (Pair<URI, Literal> dataStatement : this.dataStatements) {
                this.statements.add((Statement)new StatementImpl(this.entityUriImpl, (URI)dataStatement.getLeft(), (Value)dataStatement.getRight()));
            }
            this.statements.addAll(this.restoredStatements);
        }

        private void finishSingleLabelMode() {
            if (Munger.this.singleLabelModeLanguages != null) {
                this.singleLabelModeWorkForLabel.addBestStatement(this.statements);
                this.singleLabelModeWorkForDescription.addBestStatement(this.statements);
            }
        }

        private void registerExtraValidSubject(String subject) {
            this.extraValidSubjects.add(subject);
            this.restoredStatements.addAll(this.unknownSubjects.removeAll((Object)subject));
        }

        @SuppressFBWarnings(value={"LEST_LOST_EXCEPTION_STACK_TRACE"}, justification="Cause is really not needed here.")
        private Literal objectAsLiteral() {
            try {
                return (Literal)this.statement.getObject();
            }
            catch (ClassCastException e) {
                throw new ContainedException("Expected Literal in object position of:  " + this.statement);
            }
        }

        private class SingleLabelModeWork {
            private Statement bestStatement;
            private int bestIndex = -1;

            private SingleLabelModeWork() {
            }

            public boolean statement() {
                Literal object = MungeOperation.this.objectAsLiteral();
                String language = object.getLanguage();
                int index = Munger.this.singleLabelModeLanguages.indexOf(language);
                if (index > this.bestIndex) {
                    this.bestStatement = MungeOperation.this.statement;
                    this.bestIndex = index;
                }
                return false;
            }

            public void addBestStatement(Collection<Statement> statements) {
                if (this.bestStatement != null) {
                    statements.add(this.bestStatement);
                }
            }
        }
    }

    public static interface FormatHandler {
        public Statement handle(Statement var1);
    }
}

