/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.common.log;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.LoggerFactory;

public class PerLoggerThrottler
extends Filter<ILoggingEvent> {
    private LoadingCache<Key, AtomicLong> messagesCount;
    private long threshold = 100L;
    private long cacheSize = 1000L;
    private Duration period = Duration.of(1L, ChronoUnit.MINUTES);
    private Ticker ticker = Ticker.systemTicker();

    public PerLoggerThrottler() {
        this.messagesCount = this.createMessagesCount(this.period, this.cacheSize, this.ticker);
    }

    private LoadingCache<Key, AtomicLong> createMessagesCount(Duration period, long cacheSize, Ticker ticker) {
        return CacheBuilder.newBuilder().expireAfterWrite(period.toMillis(), TimeUnit.MILLISECONDS).maximumSize(cacheSize).removalListener(this::onRemoval).ticker(ticker).build(new CacheLoader<Key, AtomicLong>(){

            @Override
            public AtomicLong load(Key key) {
                return new AtomicLong();
            }
        });
    }

    private void onRemoval(Map.Entry<Key, AtomicLong> notification) {
        long nbSuppressedMessages = notification.getValue().get() - this.threshold;
        if (nbSuppressedMessages > 0L) {
            LoggerFactory.getLogger(notification.getKey().loggerName).warn("Message [{}] was duplicated {} times.", (Object)notification.getKey().messageTemplate, (Object)nbSuppressedMessages);
        }
    }

    @Override
    public FilterReply decide(ILoggingEvent event) {
        try {
            AtomicLong count = this.messagesCount.get(new Key(event.getLoggerName(), event.getMessage()));
            long newCount = count.incrementAndGet();
            if (newCount > this.threshold) {
                return FilterReply.DENY;
            }
            return FilterReply.NEUTRAL;
        }
        catch (ExecutionException ignore) {
            return FilterReply.NEUTRAL;
        }
    }

    public void setCacheSize(long cacheSize) {
        this.cacheSize = cacheSize;
        this.messagesCount = this.createMessagesCount(this.period, cacheSize, this.ticker);
    }

    public void setPeriodInMillis(long periodInMillis) {
        this.period = Duration.of(periodInMillis, ChronoUnit.MILLIS);
        this.messagesCount = this.createMessagesCount(this.period, this.cacheSize, this.ticker);
    }

    public void setThreshold(long threshold) {
        this.threshold = threshold;
    }

    @VisibleForTesting
    void setTicker(Ticker ticker) {
        this.ticker = ticker;
        this.messagesCount = this.createMessagesCount(this.period, this.cacheSize, ticker);
    }

    private static final class Key {
        private final String loggerName;
        private final String messageTemplate;

        private Key(String loggerName, String messageTemplate) {
            this.loggerName = loggerName;
            this.messageTemplate = messageTemplate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.loggerName, key.loggerName) && Objects.equals(this.messageTemplate, key.messageTemplate);
        }

        public int hashCode() {
            return Objects.hash(this.loggerName, this.messageTemplate);
        }
    }
}

