/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.common.uri;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@SuppressFBWarnings(value={"FCBL_FIELD_COULD_BE_LOCAL"}, justification="keeping `rootHttps` as an instance variable to be coherent with other fields")
public class WikibaseUris {
    public static final WikibaseUris WIKIDATA = WikibaseUris.forHost("www.wikidata.org");
    public static final String WIKIBASE_HOST_PROPERTY = "wikibaseHost";
    public static final String WIKIBASE_CONCEPT_URI = "wikibaseConceptUri";
    private static WikibaseUris uriSystem;
    private final String root;
    private final String entityData;
    private final String entityDataHttps;
    private final String entity;
    private final String statement;
    private final String value;
    private final String reference;
    private final String prop;

    public WikibaseUris(URI conceptUrl) {
        this.root = conceptUrl.toString().replaceAll("/+$", "");
        this.entityData = this.root + "/wiki/Special:EntityData/";
        this.entityDataHttps = this.otherScheme(conceptUrl) + "/wiki/Special:EntityData/";
        this.entity = this.root + "/entity/";
        this.statement = this.entity + "statement/";
        this.value = this.root + "/value/";
        this.reference = this.root + "/reference/";
        this.prop = this.root + "/prop/";
    }

    private String otherScheme(URI uri) {
        if (uri.getScheme().equals("http")) {
            return uri.toString().replace("http:", "https:").replaceAll("/+$", "");
        }
        return uri.toString().replace("https:", "http:").replaceAll("/+$", "");
    }

    @SuppressFBWarnings(value={"CBX_CUSTOM_BUILT_XML"}, justification="false positive - not actually XML")
    public StringBuilder prefixes(StringBuilder query) {
        query.append("PREFIX wdata: <").append(this.entityData).append(">\n");
        query.append("PREFIX wd: <").append(this.entity).append(">\n");
        query.append("PREFIX wds: <").append(this.statement).append(">\n");
        query.append("PREFIX wdv: <").append(this.value).append(">\n");
        query.append("PREFIX wdref: <").append(this.reference).append(">\n");
        for (PropertyType p : PropertyType.values()) {
            query.append("PREFIX ").append(p.prefix()).append(": <").append(this.prop).append(p.suffix()).append(">\n");
        }
        return query;
    }

    public String root() {
        return this.root;
    }

    public String entityData() {
        return this.entityData;
    }

    public String entityDataHttps() {
        return this.entityDataHttps;
    }

    public String entity() {
        return this.entity;
    }

    public String statement() {
        return this.statement;
    }

    public String value() {
        return this.value;
    }

    public String reference() {
        return this.reference;
    }

    public String property(PropertyType p) {
        return this.prop + p.suffix();
    }

    public String property(String suffix) {
        return this.prop + suffix;
    }

    public static WikibaseUris getURISystem() {
        if (uriSystem == null) {
            String wikibaseUriProperty = System.getProperty(WIKIBASE_CONCEPT_URI);
            if (wikibaseUriProperty != null) {
                try {
                    uriSystem = new WikibaseUris(new URI(wikibaseUriProperty));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("Bad URI host: " + wikibaseUriProperty, e);
                }
                return uriSystem;
            }
            String wikibaseHostProperty = System.getProperty(WIKIBASE_HOST_PROPERTY);
            uriSystem = wikibaseHostProperty != null ? WikibaseUris.forHost(wikibaseHostProperty) : WIKIDATA;
        }
        return uriSystem;
    }

    public static WikibaseUris forHost(String host) {
        try {
            if (host == null) {
                return WIKIDATA;
            }
            return new WikibaseUris(new URI("http://" + host));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Bad URI host: " + host, e);
        }
    }

    public static enum PropertyType {
        DIRECT("wdt", "direct/"),
        DIRECT_NORMALIZED("wdtn", "direct-normalized/"),
        STATEMENT_VALUE("psv", "statement/value/"),
        STATEMENT_VALUE_NORMALIZED("psn", "statement/value-normalized/"),
        STATEMENT("ps", "statement/"),
        QUALIFIER_VALUE("pqv", "qualifier/value/"),
        QUALIFIER_VALUE_NORMALIZED("pqn", "qualifier/value-normalized/"),
        QUALIFIER("pq", "qualifier/"),
        REFERENCE_VALUE("prv", "reference/value/"),
        REFERENCE_VALUE_NORMALIZED("prn", "reference/value-normalized/"),
        REFERENCE("pr", "reference/"),
        NOVALUE("wdno", "novalue/"),
        CLAIM("p", "");

        private final String prefix;
        private final String suffix;

        private PropertyType(String p, String s) {
            this.prefix = p;
            this.suffix = s;
        }

        public String prefix() {
            return this.prefix;
        }

        protected String suffix() {
            return this.suffix;
        }

        public static List<String> suffixes() {
            return PropertyType.suffixes(PropertyType.values());
        }

        public static List<String> suffixes(PropertyType[] values) {
            return Stream.of(values).map(v -> v.suffix).collect(Collectors.toList());
        }

        public static PropertyType[] V001() {
            return new PropertyType[]{DIRECT, STATEMENT_VALUE, STATEMENT, QUALIFIER_VALUE, QUALIFIER, REFERENCE_VALUE, REFERENCE, NOVALUE, CLAIM};
        }
    }
}

