/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.openrdf.model.Statement;

public class FilteredStatements {
    private final Collection<Statement> statements;

    public static FilteredStatements filtered(Collection<Statement> statements) {
        return new FilteredStatements(statements);
    }

    public FilteredStatements(Collection<Statement> statements) {
        this.statements = statements;
    }

    public Collection<Statement> withSubject(String subject) {
        return this.statements.stream().filter(statement -> subject.equals(statement.getSubject().stringValue())).collect(ImmutableList.toImmutableList());
    }

    public Collection<Statement> withSubjectStarts(String prefix) {
        return this.statements.stream().filter(statement -> statement.getSubject().stringValue().startsWith(prefix)).collect(ImmutableList.toImmutableList());
    }
}

