/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool;

import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.wikidata.query.rdf.tool.StreamUtils;

public final class CliUtils {
    public static Reader reader(String uri) throws IOException {
        return StreamUtils.utf8(CliUtils.inputStream(uri));
    }

    public static InputStream inputStream(String uri) throws IOException {
        if (uri.equals("-")) {
            return ForbiddenOk.systemDotIn();
        }
        InputStream stream = !uri.contains(":/") ? new BufferedInputStream(Files.newInputStream(Paths.get(uri, new String[0]), new OpenOption[0])) : URI.create(uri).toURL().openStream();
        if (uri.endsWith(".gz")) {
            stream = new GZIPInputStream(stream);
        }
        return stream;
    }

    public static Writer writer(String uri) throws IOException {
        return StreamUtils.utf8(CliUtils.outputStream(uri));
    }

    public static OutputStream outputStream(String out) throws IOException {
        if (out.equals("-")) {
            return ForbiddenOk.systemDotOut();
        }
        Path path = Paths.get(out, new String[0]);
        Path parent = path.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("Invalid path: " + out);
        }
        Files.createDirectories(parent, new FileAttribute[0]);
        FilterOutputStream stream = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));
        if (out.endsWith(".gz")) {
            stream = new GZIPOutputStream(stream);
        }
        return stream;
    }

    private CliUtils() {
    }

    @SuppressForbidden
    public static final class ForbiddenOk {
        private ForbiddenOk() {
        }

        public static InputStream systemDotIn() {
            return System.in;
        }

        public static PrintStream systemDotOut() {
            return System.out;
        }

        public static PrintStream systemDotErr() {
            return System.err;
        }
    }
}

