/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool.change;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.tool.MapperUtils;

public class JsonDeserializer<T>
implements Deserializer<T> {
    private static final Logger logger = LoggerFactory.getLogger(JsonDeserializer.class);
    private final ObjectMapper mapper = MapperUtils.getObjectMapper();
    private final Map<String, Class<? extends T>> topicToClass;

    public JsonDeserializer(Map<String, Class<? extends T>> topicToClass) {
        this.topicToClass = topicToClass;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public T deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(data, this.topicToClass.get(topic));
        }
        catch (IOException e) {
            String dataString = new String(data, StandardCharsets.UTF_8);
            logger.warn("Data in topic {} cannot be deserialized [{}].", new Object[]{topic, dataString, e});
            return null;
        }
    }

    public void close() {
    }
}

