/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool.change.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import org.wikidata.query.rdf.tool.change.events.EventWithMeta;
import org.wikidata.query.rdf.tool.change.events.EventsMeta;

@SuppressFBWarnings(value={"DMC_DUBIOUS_MAP_COLLECTION"}, justification="added/removed are maps in JSON")
public class PropertiesChangeEvent
extends EventWithMeta {
    private final String title;
    private final long namespace;
    private final Map<String, String> added;
    private final Map<String, String> removed;

    @JsonCreator
    public PropertiesChangeEvent(@JsonProperty(value="meta") EventsMeta meta, @JsonProperty(value="page_title") String title, @JsonProperty(value="page_namespace") long namespace, @JsonProperty(value="added_properties") Map<String, String> added, @JsonProperty(value="removed_properties") Map<String, String> removed) {
        super(meta);
        this.title = title;
        this.namespace = namespace;
        this.added = added;
        this.removed = removed;
    }

    @Override
    public long revision() {
        return -1L;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public long namespace() {
        return this.namespace;
    }

    @Override
    public boolean isRedundant() {
        if (this.removed != null && !this.removed.isEmpty()) {
            return false;
        }
        if (this.added == null || this.added.isEmpty()) {
            return true;
        }
        return this.added.entrySet().stream().anyMatch(entry -> !((String)entry.getKey()).startsWith("wb-"));
    }
}

