/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.impl;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Value;
import org.openrdf.query.AbstractBindingSet;
import org.openrdf.query.Binding;
import org.openrdf.query.impl.BindingImpl;

public class ListBindingSet
extends AbstractBindingSet {
    private static final long serialVersionUID = -2907809218835403743L;
    private final List<String> bindingNames;
    private final List<? extends Value> values;

    public ListBindingSet(List<String> names, Value ... values) {
        this(names, Arrays.asList(values));
    }

    public ListBindingSet(List<String> bindingNames, List<? extends Value> values) {
        assert (bindingNames.size() == values.size()) : "number of binding names and values not equal";
        this.bindingNames = bindingNames;
        this.values = values;
    }

    @Override
    public Set<String> getBindingNames() {
        return new LinkedHashSet<String>(this.bindingNames);
    }

    @Override
    public Value getValue(String bindingName) {
        int idx = this.bindingNames.indexOf(bindingName);
        if (idx != -1) {
            return this.values.get(idx);
        }
        return null;
    }

    @Override
    public Binding getBinding(String bindingName) {
        Value value = this.getValue(bindingName);
        if (value != null) {
            return new BindingImpl(bindingName, value);
        }
        return null;
    }

    @Override
    public boolean hasBinding(String bindingName) {
        return this.getValue(bindingName) != null;
    }

    @Override
    public Iterator<Binding> iterator() {
        return new ListBindingSetIterator();
    }

    @Override
    public int size() {
        int size = 0;
        for (Value value : this.values) {
            if (value == null) continue;
            ++size;
        }
        return size;
    }

    private class ListBindingSetIterator
    implements Iterator<Binding> {
        private int index = -1;

        public ListBindingSetIterator() {
            this.findNextElement();
        }

        private void findNextElement() {
            ++this.index;
            while (this.index < ListBindingSet.this.values.size() && ListBindingSet.this.values.get(this.index) == null) {
                ++this.index;
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < ListBindingSet.this.values.size();
        }

        @Override
        public Binding next() {
            BindingImpl result = new BindingImpl((String)ListBindingSet.this.bindingNames.get(this.index), (Value)ListBindingSet.this.values.get(this.index));
            this.findNextElement();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

