/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.common.uri;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.wikidata.query.rdf.common.uri.PropertyType;
import org.wikidata.query.rdf.common.uri.UrisScheme;

@Immutable
public class DefaultUrisScheme
implements UrisScheme {
    private final String root;
    private final String entityData;
    private final String entityDataHttps;
    private final String entity;
    private final String statement;
    private final String value;
    private final String reference;
    private final String prop;
    private final String entityPrefix;
    private final String entityDataPrefix;
    private final List<String> initials;

    public DefaultUrisScheme(URI conceptUrl, String entityPrefix, String entityDataPrefix, List<String> wikibaseInitials) {
        this.root = conceptUrl.toString().replaceAll("/+$", "");
        this.entityData = this.root + "/wiki/Special:EntityData/";
        this.entityDataHttps = this.otherScheme(conceptUrl) + "/wiki/Special:EntityData/";
        this.entity = this.root + "/entity/";
        this.statement = this.entity + "statement/";
        this.value = this.root + "/value/";
        this.reference = this.root + "/reference/";
        this.prop = this.root + "/prop/";
        this.entityPrefix = entityPrefix;
        this.entityDataPrefix = entityDataPrefix;
        this.initials = ImmutableList.copyOf(wikibaseInitials);
    }

    private String otherScheme(URI uri) {
        if (uri.getScheme().equals("http")) {
            return uri.toString().replace("http:", "https:").replaceAll("/+$", "");
        }
        return uri.toString().replace("https:", "http:").replaceAll("/+$", "");
    }

    @Override
    @SuppressFBWarnings(value={"CBX_CUSTOM_BUILT_XML"}, justification="false positive - not actually XML")
    public StringBuilder prefixes(StringBuilder query) {
        this.entityPrefixes().forEach((k, v) -> query.append("PREFIX ").append((String)k).append(": <").append((String)v).append(">\n"));
        query.append("PREFIX wds: <").append(this.statement).append(">\n");
        query.append("PREFIX wdv: <").append(this.value).append(">\n");
        query.append("PREFIX wdref: <").append(this.reference).append(">\n");
        for (PropertyType p : PropertyType.values()) {
            query.append("PREFIX ").append(p.prefix()).append(": <").append(this.prop).append(p.suffix()).append(">\n");
        }
        return query;
    }

    @Override
    public String root() {
        return this.root;
    }

    @Override
    public String entityData() {
        return this.entityData;
    }

    @Override
    public String entityDataHttps() {
        return this.entityDataHttps;
    }

    protected String entity() {
        return this.entity;
    }

    @Override
    public String entityIdToURI(String entityId) {
        return this.entity + entityId;
    }

    @Override
    public String entityURItoId(String uri) {
        if (uri.startsWith(this.entity)) {
            return uri.substring(this.entity.length());
        }
        return uri;
    }

    @Override
    public boolean isEntityURI(String uri) {
        return uri.startsWith(this.entity);
    }

    @Override
    public Collection<String> entityURIs() {
        return Collections.singletonList(this.entity);
    }

    @Override
    public Map<String, String> entityPrefixes() {
        return ImmutableMap.of(this.entityPrefix, this.entity, this.entityDataPrefix, this.entityData());
    }

    public List<String> entityInitials() {
        return this.initials;
    }

    @Override
    public String statement() {
        return this.statement;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public String reference() {
        return this.reference;
    }

    @Override
    public String property(PropertyType p) {
        return this.property(p.suffix());
    }

    @Override
    public String property(String suffix) {
        return this.prop + suffix;
    }

    @Override
    public boolean supportsUri(String uri) {
        return uri.startsWith(this.root());
    }

    @Override
    public boolean supportsInitial(String entityId) {
        for (String initial : this.entityInitials()) {
            if (!entityId.startsWith(initial)) continue;
            return true;
        }
        return false;
    }
}

