/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.common.uri;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.wikidata.query.rdf.common.uri.PropertyType;
import org.wikidata.query.rdf.common.uri.UrisScheme;

@Immutable
public class FederatedUrisScheme
implements UrisScheme {
    private final UrisScheme mainUris;
    private final UrisScheme federatedUris;
    private final List<String> entityURIs;
    private final Map<String, String> entityPrefixes;
    private final List<String> entityInitials;

    public FederatedUrisScheme(UrisScheme mainUris, UrisScheme federatedUris) {
        this.mainUris = mainUris;
        this.federatedUris = federatedUris;
        this.entityURIs = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(federatedUris.entityURIs())).addAll(mainUris.entityURIs())).build();
        this.entityPrefixes = ImmutableMap.builder().putAll(federatedUris.entityPrefixes()).putAll(mainUris.entityPrefixes()).build();
        this.entityInitials = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(federatedUris.entityInitials())).addAll(mainUris.entityInitials())).build();
    }

    @Override
    public StringBuilder prefixes(StringBuilder query) {
        return this.mainUris.prefixes(query);
    }

    @Override
    public String root() {
        return this.mainUris.root();
    }

    @Override
    public String entityData() {
        return this.mainUris.entityData();
    }

    @Override
    public String entityDataHttps() {
        return this.mainUris.entityDataHttps();
    }

    @Override
    public String entityIdToURI(String entityId) {
        if (this.mainUris.supportsInitial(entityId)) {
            return this.mainUris.entityIdToURI(entityId);
        }
        return this.federatedUris.entityIdToURI(entityId);
    }

    @Override
    public String entityURItoId(String uri) {
        if (this.mainUris.supportsUri(uri)) {
            return this.mainUris.entityURItoId(uri);
        }
        return this.federatedUris.entityURItoId(uri);
    }

    @Override
    public boolean isEntityURI(String uri) {
        if (this.mainUris.supportsUri(uri)) {
            return this.mainUris.isEntityURI(uri);
        }
        return this.federatedUris.isEntityURI(uri);
    }

    @Override
    public Collection<String> entityURIs() {
        return this.entityURIs;
    }

    @Override
    public Map<String, String> entityPrefixes() {
        return this.entityPrefixes;
    }

    @Override
    public Collection<String> entityInitials() {
        return this.entityInitials;
    }

    @Override
    public String statement() {
        return this.mainUris.statement();
    }

    @Override
    public String value() {
        return this.mainUris.value();
    }

    @Override
    public String reference() {
        return this.mainUris.reference();
    }

    @Override
    public String property(PropertyType p) {
        return this.mainUris.property(p);
    }

    @Override
    public String property(String suffix) {
        return this.mainUris.property(suffix);
    }

    @Override
    public boolean supportsUri(String uri) {
        return this.mainUris.supportsUri(uri) || this.federatedUris.supportsUri(uri);
    }

    @Override
    public boolean supportsInitial(String entityId) {
        return this.mainUris.supportsUri(entityId) || this.federatedUris.supportsUri(entityId);
    }
}

