/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.common.uri;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum PropertyType {
    DIRECT("wdt", "direct/"),
    DIRECT_NORMALIZED("wdtn", "direct-normalized/"),
    STATEMENT_VALUE("psv", "statement/value/"),
    STATEMENT_VALUE_NORMALIZED("psn", "statement/value-normalized/"),
    STATEMENT("ps", "statement/"),
    QUALIFIER_VALUE("pqv", "qualifier/value/"),
    QUALIFIER_VALUE_NORMALIZED("pqn", "qualifier/value-normalized/"),
    QUALIFIER("pq", "qualifier/"),
    REFERENCE_VALUE("prv", "reference/value/"),
    REFERENCE_VALUE_NORMALIZED("prn", "reference/value-normalized/"),
    REFERENCE("pr", "reference/"),
    NOVALUE("wdno", "novalue/"),
    CLAIM("p", "");

    private final String prefix;
    private final String suffix;

    private PropertyType(String p, String s) {
        this.prefix = p;
        this.suffix = s;
    }

    public String prefix() {
        return this.prefix;
    }

    protected String suffix() {
        return this.suffix;
    }

    public static List<String> suffixes() {
        return PropertyType.suffixes(PropertyType.values());
    }

    public static List<String> suffixes(PropertyType[] values) {
        return Stream.of(values).map(v -> v.suffix).collect(Collectors.toList());
    }

    public static PropertyType[] V001() {
        return new PropertyType[]{DIRECT, STATEMENT_VALUE, STATEMENT, QUALIFIER_VALUE, QUALIFIER, REFERENCE_VALUE, REFERENCE, NOVALUE, CLAIM};
    }
}

