/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.common.uri;

import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.wikidata.query.rdf.common.uri.DefaultUrisScheme;
import org.wikidata.query.rdf.common.uri.FederatedUrisScheme;
import org.wikidata.query.rdf.common.uri.UrisConstants;
import org.wikidata.query.rdf.common.uri.UrisScheme;

public final class UrisSchemeFactory {
    public static final UrisScheme WIKIDATA = UrisSchemeFactory.forHost("www.wikidata.org");
    private static final UrisScheme uriSystem = UrisSchemeFactory.initializeURISystem();

    private UrisSchemeFactory() {
    }

    public static UrisScheme getURISystem() {
        return uriSystem;
    }

    private static UrisScheme initializeURISystem() {
        String wikibaseUriProperty = System.getProperty("wikibaseConceptUri");
        if (wikibaseUriProperty != null) {
            return UrisSchemeFactory.fromConceptUris(wikibaseUriProperty, System.getProperty("commonsConceptUri"));
        }
        String wikibaseHostProperty = System.getProperty("wikibaseHost");
        if (wikibaseHostProperty != null) {
            return UrisSchemeFactory.forHost(wikibaseHostProperty);
        }
        return WIKIDATA;
    }

    public static UrisScheme fromConceptUris(@Nonnull String wikibaseConceptUri, @Nullable String commonsConceptUri) {
        try {
            if (commonsConceptUri != null) {
                DefaultUrisScheme sdcUris = new DefaultUrisScheme(new URI(commonsConceptUri), "sdc", "sdcdata", UrisConstants.MEDIAINFO_INITIAL);
                DefaultUrisScheme wikibaseUris = new DefaultUrisScheme(new URI(wikibaseConceptUri), "wd", "wdata", UrisConstants.WIKIBASE_INITIALS);
                return new FederatedUrisScheme(sdcUris, wikibaseUris);
            }
            return new DefaultUrisScheme(new URI(wikibaseConceptUri), "wd", "wdata", UrisConstants.WIKIBASE_INITIALS);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Bad URI: " + wikibaseConceptUri + (commonsConceptUri != null ? ", " + commonsConceptUri : ""), e);
        }
    }

    public static UrisScheme forHost(@Nonnull String host) {
        try {
            return new DefaultUrisScheme(new URI("http://" + host), "wd", "wdata", UrisConstants.WIKIBASE_INITIALS);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Bad URI host: " + host, e);
        }
    }
}

