/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool;

import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.wikidata.query.rdf.tool.exception.FatalException;

public final class Utils {
    public static <T extends Comparable<? super T>> T max(T a, T b) {
        if (a == null) {
            return b == null ? null : (T)b;
        }
        if (b == null) {
            return a;
        }
        return a.compareTo(b) >= 0 ? a : b;
    }

    public static <T> String loadBody(String name, Class<T> klass) {
        URL url = Resources.getResource(klass, klass.getSimpleName() + "." + name + ".sparql");
        try {
            return Resources.toString(url, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new FatalException("Can't load " + url, e);
        }
    }

    private Utils() {
    }
}

