/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool.change;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.openrdf.model.Statement;
import org.wikidata.query.rdf.tool.exception.RetryableException;
import org.wikidata.query.rdf.tool.wikibase.WikibaseRepository;

@SuppressFBWarnings(value={"FCCD_FIND_CLASS_CIRCULAR_DEPENDENCY"})
public class Change
implements Comparable<Change> {
    public static final long NO_REVISION = -1L;
    private final String entityId;
    private final long revision;
    private final Instant timestamp;
    private final String chronologyId;
    private Collection<Statement> statements;
    private Collection<String> refCleanupList = Collections.emptyList();
    private Collection<String> valueCleanupList = Collections.emptyList();
    private final long offset;

    public Change(String entityId, long revision, Instant timestamp, long offset) {
        this(entityId, revision, timestamp, offset, null);
    }

    public Change(String entityId, long revision, Instant timestamp, long offset, String chronologyId) {
        this.entityId = this.cleanEntityId(entityId);
        this.revision = revision;
        this.timestamp = timestamp;
        this.offset = offset;
        this.chronologyId = chronologyId;
    }

    private String cleanEntityId(String entityIdWithPrefix) {
        if (entityIdWithPrefix.startsWith("Property:")) {
            return entityIdWithPrefix.substring("Property:".length());
        }
        if (entityIdWithPrefix.startsWith("Item:")) {
            return entityIdWithPrefix.substring("Item:".length());
        }
        if (entityIdWithPrefix.startsWith("Lexeme:")) {
            return entityIdWithPrefix.substring("Lexeme:".length());
        }
        return entityIdWithPrefix;
    }

    public String entityId() {
        return this.entityId;
    }

    public long revision() {
        return this.revision;
    }

    public long offset() {
        return this.offset;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public String chronologyId() {
        return this.chronologyId;
    }

    public String toString() {
        if (this.revision < -1L && this.timestamp == null) {
            return this.entityId;
        }
        StringBuilder b = new StringBuilder();
        b.append(this.entityId);
        if (this.revision >= 0L) {
            b.append('@').append(this.revision);
        }
        if (this.timestamp != null) {
            b.append('@').append(WikibaseRepository.OUTPUT_DATE_FORMATTER.format(this.timestamp));
            b.append('|').append(this.offset);
        }
        return b.toString();
    }

    @Override
    @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"}, justification="This looks suspicious, but would need more investigation")
    public int compareTo(Change o) {
        return (int)(this.offset() - o.offset());
    }

    public Collection<Statement> getStatements() {
        return this.statements;
    }

    public void setStatements(Collection<Statement> statements) {
        this.statements = statements;
    }

    public Collection<String> getValueCleanupList() {
        return this.valueCleanupList;
    }

    public Collection<String> getRefCleanupList() {
        return this.refCleanupList;
    }

    public void setRefCleanupList(Collection<String> cleanupList) {
        this.refCleanupList = cleanupList;
    }

    public void setValueCleanupList(Collection<String> cleanupList) {
        this.valueCleanupList = cleanupList;
    }

    public void delay(Queue<DelayedChange> queue, long timeout) {
        queue.add(new DelayedChange(timeout));
    }

    public class DelayedChange
    implements Delayed {
        private final Instant expires;

        DelayedChange(long delay) {
            this.expires = Instant.now().plusSeconds(delay);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(Duration.between(Instant.now(), this.expires).toNanos(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            DelayedChange other = (DelayedChange)o;
            return this.expires.compareTo(other.expires);
        }

        public boolean equals(Object o) {
            return o instanceof DelayedChange && this.getChange() == ((DelayedChange)o).getChange();
        }

        public int hashCode() {
            return this.getChange().hashCode();
        }

        public Change getChange() {
            return Change.this;
        }
    }

    public static interface Batch {
        public List<Change> changes();

        public boolean hasAnyChanges();

        public String advancedUnits();

        public long advanced();

        public String leftOffHuman();

        public Instant leftOffDate();

        public boolean last();

        public static abstract class AbstractDefaultImplementation
        implements Batch {
            private final ImmutableList<Change> changes;
            private final long advanced;
            private final Object leftOff;

            public AbstractDefaultImplementation(ImmutableList<Change> changes, long advanced, Object leftOff) {
                this.changes = Preconditions.checkNotNull(changes);
                this.advanced = advanced;
                this.leftOff = leftOff;
            }

            @Override
            public List<Change> changes() {
                return this.changes;
            }

            @Override
            public boolean hasAnyChanges() {
                return !this.changes.isEmpty();
            }

            @Override
            public long advanced() {
                return this.advanced;
            }

            @Override
            public String leftOffHuman() {
                return this.leftOff.toString();
            }

            @Override
            public boolean last() {
                return false;
            }
        }
    }

    public static interface Source<B extends Batch>
    extends Closeable {
        public B firstBatch() throws RetryableException;

        public B nextBatch(B var1) throws RetryableException;
    }
}

