/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool.change;

import com.codahale.metrics.MetricRegistry;
import java.net.URI;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.tool.change.Change;
import org.wikidata.query.rdf.tool.change.IdListChangeSource;
import org.wikidata.query.rdf.tool.change.IdRangeChangeSource;
import org.wikidata.query.rdf.tool.change.KafkaPoller;
import org.wikidata.query.rdf.tool.change.RdfKafkaOffsetsRepository;
import org.wikidata.query.rdf.tool.change.RecentChangesPoller;
import org.wikidata.query.rdf.tool.options.UpdateOptions;
import org.wikidata.query.rdf.tool.rdf.RdfRepository;
import org.wikidata.query.rdf.tool.rdf.client.RdfClient;
import org.wikidata.query.rdf.tool.wikibase.WikibaseRepository;

public final class ChangeSourceContext {
    private static final Logger log = LoggerFactory.getLogger(ChangeSourceContext.class);
    private static final String MAX_DAYS_BACK_NAME = "wikibaseMaxDaysBack";

    private ChangeSourceContext() {
    }

    @Nonnull
    public static Change.Source<? extends Change.Batch> buildChangeSource(UpdateOptions options, Instant startTime, WikibaseRepository wikibaseRepository, RdfClient rdfClient, URI root, MetricRegistry metricRegistry) {
        if (options.idrange() != null) {
            return ChangeSourceContext.buildIdRangeChangeSource(options.idrange(), options.batchSize());
        }
        if (options.ids() != null) {
            return new IdListChangeSource(UpdateOptions.parsedIds(options), options.batchSize());
        }
        if (options.kafkaBroker() != null) {
            RdfKafkaOffsetsRepository kafkaOffsetsRepository = new RdfKafkaOffsetsRepository(root, rdfClient);
            return KafkaPoller.buildKafkaPoller(options.kafkaBroker(), options.consumerId(), UpdateOptions.clusterNames(options), wikibaseRepository.getUris(), options.batchSize(), startTime, UpdateOptions.ignoreStoredOffsets(options), kafkaOffsetsRepository, metricRegistry);
        }
        return new RecentChangesPoller(wikibaseRepository, startTime, options.batchSize(), options.tailPollerOffset(), metricRegistry);
    }

    @Nonnull
    public static Instant getStartTime(Instant startInstant, RdfRepository rdfRepository, boolean init) {
        if (startInstant != null) {
            if (init) {
                rdfRepository.updateLeftOffTime(startInstant);
            }
        } else {
            log.info("Checking where we left off");
            Instant leftOff = rdfRepository.fetchLeftOffTime();
            Integer maxDays = Integer.valueOf(System.getProperty(MAX_DAYS_BACK_NAME, "30"));
            Instant minStartTime = Instant.now().minus(maxDays.intValue(), ChronoUnit.DAYS);
            if (leftOff == null) {
                startInstant = minStartTime;
                log.info("Defaulting start time to {} days ago: {}", (Object)maxDays, (Object)startInstant);
            } else {
                if (leftOff.isBefore(minStartTime)) {
                    throw new IllegalStateException("RDF store reports the last update time is before the minimum safe poll time.  You will have to reload from scratch or you might have missing data.");
                }
                startInstant = leftOff;
                log.info("Found start time in the RDF store: {}", (Object)leftOff);
            }
        }
        return startInstant;
    }

    private static Change.Source<? extends Change.Batch> buildIdRangeChangeSource(String idrange, int batchSize) {
        long end;
        long start;
        String[] ids = idrange.split("-");
        switch (ids.length) {
            case 1: {
                if (!Character.isDigit(ids[0].charAt(0))) {
                    return new IdListChangeSource(ids, batchSize);
                }
                end = start = Long.parseLong(ids[0]);
                break;
            }
            case 2: {
                start = Long.parseLong(ids[0]);
                end = Long.parseLong(ids[1]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid format for --idrange.  Need <start>-<stop>.");
            }
        }
        return IdRangeChangeSource.forItems(start, end, batchSize);
    }
}

