/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool.options;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import com.google.common.base.Splitter;
import com.google.common.io.Resources;
import com.lexicalscope.jewel.cli.ArgumentValidationException;
import com.lexicalscope.jewel.cli.Cli;
import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.HelpRequestedException;
import com.lexicalscope.jewel.cli.Option;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.common.uri.UrisScheme;
import org.wikidata.query.rdf.common.uri.UrisSchemeFactory;
import org.wikidata.query.rdf.tool.CliUtils;
import org.wikidata.query.rdf.tool.rdf.Munger;

public final class OptionsUtils {
    private static final Logger log = LoggerFactory.getLogger(OptionsUtils.class);

    public static <T extends BasicOptions> T handleOptions(Class<T> optionsClass, String ... args) {
        BasicOptions options = (BasicOptions)OptionsUtils.parseOptions(optionsClass, args);
        if (options.verbose()) {
            log.info("Verbose mode activated");
            LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
            try {
                JoranConfigurator configurator = new JoranConfigurator();
                configurator.setContext(context);
                context.reset();
                configurator.doConfigure(Resources.getResource("logback-verbose.xml"));
            }
            catch (JoranException joranException) {
                // empty catch block
            }
            StatusPrinter.printInCaseOfErrorsOrWarnings(context);
        }
        return (T)options;
    }

    public static List<String> splitByComma(List<String> options) {
        if (options == null) {
            return null;
        }
        LinkedList<String> newOptions = new LinkedList<String>();
        for (String option : options) {
            if (option.contains(",")) {
                newOptions.addAll(Splitter.on(",").splitToList(option));
                continue;
            }
            newOptions.add(option);
        }
        return newOptions;
    }

    public static Munger mungerFromOptions(MungerOptions options) {
        Munger.Builder builder = Munger.builder(WikibaseOptions.wikibaseUris(options));
        if (options.skipSiteLinks()) {
            builder = builder.removeSiteLinks();
        }
        if (options.labelLanguages() != null) {
            builder = builder.limitLabelLanguages(OptionsUtils.splitByComma(options.labelLanguages()));
        }
        if (options.singleLabelLanguages() != null) {
            builder = builder.singleLabelMode(OptionsUtils.splitByComma(options.singleLabelLanguages()));
        }
        if (options.keepTypes()) {
            builder = builder.keepTypes(true);
        }
        return builder.build();
    }

    private static <T> T parseOptions(Class<T> optionsClass, String ... args) {
        Cli<T> cli = CliFactory.createCli(optionsClass);
        try {
            return cli.parseArguments(args);
        }
        catch (HelpRequestedException e) {
            CliUtils.ForbiddenOk.systemDotOut().println(cli.getHelpMessage());
            System.exit(0);
        }
        catch (ArgumentValidationException e) {
            CliUtils.ForbiddenOk.systemDotErr().println("Invalid argument:  " + e);
            CliUtils.ForbiddenOk.systemDotErr().println(cli.getHelpMessage());
            System.exit(1);
        }
        throw new RuntimeException("Should be unreachable.");
    }

    private OptionsUtils() {
    }

    public static interface WikibaseOptions {
        @Option(shortName={"w"}, defaultValue={"www.wikidata.org"}, description="Wikibase host")
        public String wikibaseHost();

        @Option(shortName={"U"}, defaultToNull=true, description="Wikibase concept URI for RDF entities")
        public String conceptUri();

        @Option(defaultToNull=true, description="Commons concept URI for RDF entities")
        public String commonsUri();

        public static UrisScheme wikibaseUris(WikibaseOptions wikibaseOptions) {
            String conceptUri = wikibaseOptions.conceptUri();
            if (conceptUri != null) {
                return UrisSchemeFactory.fromConceptUris(conceptUri, wikibaseOptions.commonsUri());
            }
            return UrisSchemeFactory.forHost(wikibaseOptions.wikibaseHost());
        }
    }

    public static interface MungerOptions
    extends WikibaseOptions {
        @Option(longName={"labelLanguage"}, defaultToNull=true, description="Only import labels, aliases, and descriptions in these languages.")
        public List<String> labelLanguages();

        @Option(longName={"singleLabel"}, defaultToNull=true, description="Only import a single label and description using the languages specified as a fallback list. If there isn't a label in any of the specified languages then no label is imported.  Ditto for description.")
        public List<String> singleLabelLanguages();

        @Option(description="Skip site links")
        public boolean skipSiteLinks();

        @Option(description="Preserve all types")
        public boolean keepTypes();
    }

    public static interface BasicOptions {
        @Option(shortName={"v"}, description="Verbose mode")
        public boolean verbose();

        @Option(helpRequest=true, description="Show this message")
        public boolean help();
    }
}

