/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool.rdf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.openrdf.model.Statement;
import org.wikidata.query.rdf.common.uri.UrisScheme;

@NotThreadSafe
public class ClassifiedStatements {
    public final List<Statement> statementStatements = new ArrayList<Statement>();
    public final List<Statement> entityStatements = new ArrayList<Statement>();
    public final Set<Statement> aboutStatements = new HashSet<Statement>();
    private final UrisScheme uris;
    private long dataSize;

    public ClassifiedStatements(UrisScheme uris) {
        this.uris = uris;
    }

    public void clear() {
        this.entityStatements.clear();
        this.aboutStatements.clear();
        this.statementStatements.clear();
        this.dataSize = 0L;
    }

    public void classify(Collection<Statement> statements, String entityId) {
        for (Statement statement : statements) {
            String subject = statement.getSubject().stringValue();
            if (subject.equals(this.uris.entityIdToURI(entityId))) {
                this.entityStatements.add(statement);
            }
            if (subject.startsWith(this.uris.statement())) {
                this.statementStatements.add(statement);
            }
            if (!(subject.equals(this.uris.entityIdToURI(entityId)) || subject.startsWith(this.uris.statement()) || subject.startsWith(this.uris.value()) || subject.startsWith(this.uris.reference()) || subject.startsWith(this.uris.entityIdToURI(entityId) + "-"))) {
                this.aboutStatements.add(statement);
            }
            this.dataSize += (long)(subject.length() + statement.getPredicate().stringValue().length() + statement.getObject().stringValue().length());
        }
    }

    public long getDataSize() {
        return this.dataSize;
    }
}

