/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool.rdf;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.wikidata.query.rdf.tool.rdf.DelegatingRdfHandler;

public class NormalizingRdfHandler
extends DelegatingRdfHandler {
    private final Pattern badchars = Pattern.compile("\u00ad|[\u200b-\u200f]|[\u202a-\u202e]|[\u2060-\u2064]|[\u206a-\u206f]");

    public NormalizingRdfHandler(RDFHandler next) {
        super(next);
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        if (uri.contains("ontology-0.0.1")) {
            uri = uri.replace("ontology-0.0.1", "ontology");
        }
        if (uri.contains("ontology-beta")) {
            uri = uri.replace("ontology-beta", "ontology");
        }
        super.handleNamespace(prefix, uri);
    }

    @Override
    public void handleStatement(Statement statement) throws RDFHandlerException {
        Resource subject = statement.getSubject();
        URI predicate = statement.getPredicate();
        Value object = statement.getObject();
        if (subject instanceof URI) {
            subject = this.fixUri((URI)subject);
        }
        predicate = this.fixUri(predicate);
        if (object instanceof URI) {
            object = this.fixUri((URI)object);
        } else if (object instanceof Literal) {
            object = this.fixLiteral((Literal)object);
        }
        if (subject != statement.getSubject() || predicate != statement.getPredicate() || object != statement.getObject()) {
            statement = new StatementImpl(subject, predicate, object);
        }
        super.handleStatement(statement);
    }

    private boolean isNumericString(String s) {
        int i = 0;
        if (s.length() == 0) {
            return false;
        }
        char[] chars = s.toCharArray();
        boolean seenDot = false;
        if (chars[0] == '+' || chars[0] == '-') {
            ++i;
        }
        while (i < s.length()) {
            if (chars[i] == '.') {
                if (seenDot) {
                    return false;
                }
                seenDot = true;
            } else if (chars[i] < '0' || chars[i] > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Value fixLiteral(Literal value) {
        String strValue;
        Matcher match;
        URI datatype = value.getDatatype();
        if (datatype.equals(XMLSchema.DECIMAL)) {
            if (!this.isNumericString(value.getLabel())) {
                return new LiteralImpl("0", XMLSchema.DECIMAL);
            }
        } else if (datatype.equals(XMLSchema.INTEGER) && !this.isNumericString(value.getLabel())) {
            return new LiteralImpl("0", XMLSchema.INTEGER);
        }
        if ((datatype.equals(RDF.LANGSTRING) || datatype.equals(XMLSchema.STRING)) && (match = this.badchars.matcher(strValue = value.getLabel())).find()) {
            if (value.getLanguage() != null) {
                return new LiteralImpl(match.replaceAll(""), value.getLanguage());
            }
            return new LiteralImpl(match.replaceAll(""), datatype);
        }
        return value;
    }

    private URI fixUri(URI r) {
        String fixed;
        if (r.stringValue().contains("ontology-0.0.1")) {
            r = new URIImpl(r.stringValue().replace("ontology-0.0.1", "ontology"));
        }
        if (r.stringValue().contains("ontology-beta")) {
            r = new URIImpl(r.stringValue().replace("ontology-beta", "ontology"));
        }
        if (!(fixed = StringUtils.replaceEach(r.stringValue(), new String[]{"\n", "|", "\\", "{", "}", "`", "^"}, new String[]{"", "%7C", "%5C", "%7B", "%7D", "%60", "%5E"})).equals(r.stringValue())) {
            r = new URIImpl(fixed);
        }
        return r;
    }
}

