/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool;

import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClientUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtils.class);
    public static final String HTTP_PROXY_PROPERTY = "http.proxyHost";
    public static final String HTTP_PROXY_PORT_PROPERTY = "http.proxyPort";
    public static final int MAX_RETRIES = 6;
    public static final int HTTP_RETRY_DELAY = 1000;

    private HttpClientUtils() {
    }

    public static void ignoreCookies(HttpRequestBase request) {
        RequestConfig noCookiesConfig = RequestConfig.custom().setCookieSpec("ignoreCookies").build();
        request.setConfig(noCookiesConfig);
    }

    @Nullable
    public static String getHttpProxyHost() {
        return System.getProperty(HTTP_PROXY_PROPERTY);
    }

    @Nullable
    public static Integer getHttpProxyPort() {
        String p = System.getProperty(HTTP_PROXY_PORT_PROPERTY);
        if (p == null) {
            return null;
        }
        return Integer.valueOf(p);
    }

    public static HttpClient buildHttpClient(@Nullable String httpProxyHost, @Nullable Integer httpProxyPort) {
        HttpClient httpClient = new HttpClient(new SslContextFactory(true));
        if (httpProxyHost != null && httpProxyPort != null) {
            ProxyConfiguration proxyConfig = httpClient.getProxyConfiguration();
            HttpProxy proxy = new HttpProxy(httpProxyHost, httpProxyPort.intValue());
            proxy.getExcludedAddresses().add("localhost");
            proxy.getExcludedAddresses().add("127.0.0.1");
            proxyConfig.getProxies().add(proxy);
        }
        try {
            httpClient.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to start HttpClient", e);
        }
        return httpClient;
    }

    public static Retryer<ContentResponse> buildHttpClientRetryer() {
        return RetryerBuilder.newBuilder().retryIfExceptionOfType(TimeoutException.class).retryIfExceptionOfType(ExecutionException.class).retryIfExceptionOfType(IOException.class).retryIfRuntimeException().withWaitStrategy(WaitStrategies.exponentialWait((long)1000L, (long)10L, (TimeUnit)TimeUnit.SECONDS)).withStopStrategy(StopStrategies.stopAfterAttempt((int)6)).withRetryListener(new RetryListener(){

            public <V> void onRetry(Attempt<V> attempt) {
                if (attempt.hasException()) {
                    log.info("HTTP request failed: {}, attempt {}, will {}", new Object[]{attempt.getExceptionCause(), attempt.getAttemptNumber(), attempt.getAttemptNumber() < 6L ? "retry" : "fail"});
                }
            }
        }).build();
    }
}

