/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool;

import com.codahale.metrics.MetricRegistry;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.common.uri.UrisScheme;
import org.wikidata.query.rdf.tool.Updater;
import org.wikidata.query.rdf.tool.change.Change;
import org.wikidata.query.rdf.tool.rdf.Munger;
import org.wikidata.query.rdf.tool.rdf.RdfRepository;
import org.wikidata.query.rdf.tool.wikibase.WikibaseRepository;

public class TestUpdater<B extends Change.Batch>
extends Updater<B> {
    private static final Logger log = LoggerFactory.getLogger(TestUpdater.class);
    private Map<String, Long> updates = new HashMap<String, Long>();

    public TestUpdater(Change.Source<B> changeSource, WikibaseRepository wikibase, RdfRepository rdfRepository, Munger munger, ExecutorService executor, int pollDelay, UrisScheme uris, boolean verify, MetricRegistry metricRegistry) {
        super(changeSource, wikibase, rdfRepository, munger, executor, pollDelay, uris, verify, metricRegistry);
    }

    @Override
    protected void handleChanges(Iterable<Change> changes) {
        for (Change change : changes) {
            log.info("C: {} {}", (Object)change.entityId(), (Object)change);
            Long old = this.updates.put(change.entityId(), change.revision());
            if (old == null) continue;
            if (old > change.revision() && change.revision() != -1L) {
                log.info("Old revision on {}: had {}, arrived {}", new Object[]{change.entityId(), old, change.revision()});
                this.updates.put(change.entityId(), old);
            }
            if (old.longValue() != change.revision() || old == -1L) continue;
            log.info("Duplicate revision on {}: {}", (Object)change.entityId(), (Object)old);
        }
    }

    @Override
    protected void syncDate(Instant newDate) {
        log.info("Sync: {}", (Object)newDate);
    }
}

