/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import com.github.rholder.retry.Retryer;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.security.Security;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.common.uri.UrisScheme;
import org.wikidata.query.rdf.tool.HttpClientUtils;
import org.wikidata.query.rdf.tool.TestUpdater;
import org.wikidata.query.rdf.tool.Updater;
import org.wikidata.query.rdf.tool.change.Change;
import org.wikidata.query.rdf.tool.change.ChangeSourceContext;
import org.wikidata.query.rdf.tool.options.OptionsUtils;
import org.wikidata.query.rdf.tool.options.UpdateOptions;
import org.wikidata.query.rdf.tool.rdf.Munger;
import org.wikidata.query.rdf.tool.rdf.RdfRepository;
import org.wikidata.query.rdf.tool.rdf.client.RdfClient;
import org.wikidata.query.rdf.tool.utils.FileStreamDumper;
import org.wikidata.query.rdf.tool.utils.NullStreamDumper;
import org.wikidata.query.rdf.tool.utils.StreamDumper;
import org.wikidata.query.rdf.tool.wikibase.WikibaseRepository;

public final class Update {
    private static final String TIMEOUT_PROPERTY = RdfRepository.class + ".timeout";
    private static final Logger log = LoggerFactory.getLogger(Update.class);
    private static final long MAX_FORM_CONTENT_SIZE = Long.getLong("RDFRepositoryMaxPostSize", 200000000L);

    private Update() {
    }

    public static void main(String[] args) throws Exception {
        try (Closer closer = Closer.create();){
            Properties buildProps = Update.loadBuildProperties();
            log.info("Starting Updater {} ({})", (Object)buildProps.getProperty("git.build.version", "UNKNOWN"), (Object)buildProps.getProperty("git.commit.id", "UNKNOWN"));
            Updater<? extends Change.Batch> updater = Update.initialize(args, closer);
            Update.run(updater);
        }
    }

    private static Properties loadBuildProperties() {
        Properties prop = new Properties();
        try (InputStream instream = Update.class.getClassLoader().getResourceAsStream("git.properties");){
            prop.load(instream);
        }
        catch (IOException e) {
            log.warn("Failed to load properties file");
        }
        return prop;
    }

    private static Updater<? extends Change.Batch> initialize(String[] args, Closer closer) throws URISyntaxException {
        try {
            UpdateOptions options = OptionsUtils.handleOptions(UpdateOptions.class, args);
            MetricRegistry metricRegistry = Update.createMetricRegistry(closer, options.metricDomain());
            StreamDumper wikibaseStreamDumper = Update.createStreamDumper(UpdateOptions.dumpDirPath(options));
            WikibaseRepository wikibaseRepository = new WikibaseRepository(UpdateOptions.uris(options), options.constraints(), metricRegistry, wikibaseStreamDumper, UpdateOptions.revisionDuration(options));
            closer.register((Closeable)wikibaseRepository);
            UrisScheme wikibaseUris = OptionsUtils.WikibaseOptions.wikibaseUris(options);
            URI root = wikibaseRepository.getUris().builder().build();
            URI sparqlUri = UpdateOptions.sparqlUri(options);
            HttpClient httpClient = HttpClientUtils.buildHttpClient(HttpClientUtils.getHttpProxyHost(), HttpClientUtils.getHttpProxyPort());
            closer.register(Update.wrapHttpClient(httpClient));
            Retryer<ContentResponse> retryer = HttpClientUtils.buildHttpClientRetryer();
            Duration rdfClientTimeout = Update.getRdfClientTimeout();
            RdfClient rdfClient = new RdfClient(httpClient, sparqlUri, retryer, rdfClientTimeout);
            RdfRepository rdfRepository = new RdfRepository(wikibaseUris, rdfClient, MAX_FORM_CONTENT_SIZE);
            Instant startTime = ChangeSourceContext.getStartTime(UpdateOptions.startInstant(options), rdfRepository, options.init());
            Change.Source<? extends Change.Batch> changeSource = ChangeSourceContext.buildChangeSource(options, startTime, wikibaseRepository, rdfClient, root, metricRegistry);
            Munger munger = OptionsUtils.mungerFromOptions(options);
            ExecutorService updaterExecutorService = Update.createUpdaterExecutorService(options.threadCount());
            Updater<? extends Change.Batch> updater = Update.createUpdater(wikibaseRepository, wikibaseUris, rdfRepository, changeSource, munger, updaterExecutorService, options.pollDelay(), options.verify(), options.testMode(), metricRegistry);
            closer.register(updater);
            return updater;
        }
        catch (Exception e) {
            log.error("Error during initialization.", (Throwable)e);
            throw e;
        }
    }

    private static StreamDumper createStreamDumper(Path dumpDir) {
        if (dumpDir == null) {
            return new NullStreamDumper();
        }
        return new FileStreamDumper(dumpDir);
    }

    private static void run(Updater<? extends Change.Batch> updater) {
        try {
            updater.run();
        }
        catch (Exception e) {
            log.error("Error during updater run.", (Throwable)e);
            throw e;
        }
    }

    private static Updater<? extends Change.Batch> createUpdater(WikibaseRepository wikibaseRepository, UrisScheme uris, RdfRepository rdfRepository, Change.Source<? extends Change.Batch> changeSource, Munger munger, ExecutorService executor, int pollDelay, boolean verify, boolean testMode, MetricRegistry metricRegistry) {
        if (testMode) {
            return new TestUpdater<Change.Batch>(changeSource, wikibaseRepository, rdfRepository, munger, executor, pollDelay, uris, verify, metricRegistry);
        }
        return new Updater<Change.Batch>(changeSource, wikibaseRepository, rdfRepository, munger, executor, pollDelay, uris, verify, metricRegistry);
    }

    private static ExecutorService createUpdaterExecutorService(int threadCount) {
        ThreadFactoryBuilder threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("update %s");
        return new ThreadPoolExecutor(threadCount, threadCount, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory.build());
    }

    public static Duration getRdfClientTimeout() {
        int timeout = Integer.parseInt(System.getProperty(TIMEOUT_PROPERTY, "-1"));
        return Duration.of(timeout, ChronoUnit.SECONDS);
    }

    private static Closeable wrapHttpClient(HttpClient httpClient) {
        return () -> {
            try {
                httpClient.stop();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not close HttpClient", e);
            }
        };
    }

    private static MetricRegistry createMetricRegistry(Closer closer, String metricDomain) {
        MetricRegistry metrics = new MetricRegistry();
        JmxReporter reporter = (JmxReporter)closer.register((Closeable)JmxReporter.forRegistry((MetricRegistry)metrics).inDomain(metricDomain).build());
        reporter.start();
        return metrics;
    }

    static {
        Security.setProperty("networkaddress.cache.negative.ttl", "5");
    }
}

