/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool.change;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.tool.Utils;
import org.wikidata.query.rdf.tool.change.Change;
import org.wikidata.query.rdf.tool.change.TailingChangesPoller;
import org.wikidata.query.rdf.tool.exception.RetryableException;
import org.wikidata.query.rdf.tool.wikibase.Continue;
import org.wikidata.query.rdf.tool.wikibase.RecentChangeResponse;
import org.wikidata.query.rdf.tool.wikibase.WikibaseRepository;

@SuppressFBWarnings(value={"FCCD_FIND_CLASS_CIRCULAR_DEPENDENCY"})
public class RecentChangesPoller
implements Change.Source<Batch> {
    private static final Logger log = LoggerFactory.getLogger(RecentChangesPoller.class);
    private static final int MAX_SEEN_IDS = 360000;
    private final WikibaseRepository wikibase;
    private final Instant firstStartTime;
    private final int batchSize;
    private final Map<Long, Boolean> seenIDs;
    private final int tailSeconds;
    private static final Duration BACKOFF_TIME = Duration.ofSeconds(10L);
    private static final Duration BACKOFF_THRESHOLD = Duration.ofMinutes(2L);
    private final BlockingQueue<Batch> queue = new ArrayBlockingQueue<Batch>(100);
    private TailingChangesPoller tailPoller;
    private boolean useBackoff = true;
    private final Timer recentChangesTimer;
    private final Counter recentChangesCounter;

    public RecentChangesPoller(WikibaseRepository wikibase, Instant firstStartTime, int batchSize, Map<Long, Boolean> seenIDs, int tailSeconds, Timer recentChangesTimer, Counter recentChangesCounter) {
        this.wikibase = wikibase;
        this.firstStartTime = firstStartTime;
        this.batchSize = batchSize;
        this.seenIDs = seenIDs;
        this.tailSeconds = tailSeconds;
        this.recentChangesTimer = recentChangesTimer;
        this.recentChangesCounter = recentChangesCounter;
    }

    public RecentChangesPoller(WikibaseRepository wikibase, Instant firstStartTime, int batchSize, MetricRegistry metricRegistry) {
        this(wikibase, firstStartTime, batchSize, RecentChangesPoller.createSeenMap(), -1, metricRegistry.timer("recent-changes-timer"), metricRegistry.counter("recent-changes-counter"));
    }

    public RecentChangesPoller(WikibaseRepository wikibase, Instant firstStartTime, int batchSize, int tailSeconds, MetricRegistry metricRegistry) {
        this(wikibase, firstStartTime, batchSize, RecentChangesPoller.createSeenMap(), tailSeconds, metricRegistry.timer("recent-changes-timer"), metricRegistry.counter("recent-changes-counter"));
    }

    public void setBackoff(boolean useBackoff) {
        this.useBackoff = useBackoff;
    }

    private static Map<Long, Boolean> createSeenMap() {
        LinkedHashMap map = new LinkedHashMap(360000, 0.75f, false){

            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > 360000;
            }
        };
        return Collections.synchronizedMap(map);
    }

    @Override
    public Batch firstBatch() throws RetryableException {
        return this.batch(this.firstStartTime, null);
    }

    @Override
    public Batch nextBatch(Batch lastBatch) throws RetryableException {
        Batch newBatch = this.batch(lastBatch.leftOffDate, lastBatch);
        if (this.tailSeconds > 0) {
            newBatch = this.checkTailPoller(newBatch);
        }
        return newBatch;
    }

    private Batch checkTailPoller(Batch lastBatch) {
        if (this.tailSeconds <= 0) {
            return lastBatch;
        }
        if (this.tailPoller == null) {
            if (lastBatch.leftOffDate().isBefore(Instant.now().minusSeconds(this.tailSeconds))) {
                return lastBatch;
            }
            log.info("Started trailing poller with gap of {} seconds", (Object)this.tailSeconds);
            RecentChangesPoller poller = new RecentChangesPoller(this.wikibase, Instant.now().minusSeconds(this.tailSeconds), this.batchSize, this.seenIDs, -1, this.recentChangesTimer, this.recentChangesCounter);
            poller.setBackoff(false);
            this.tailPoller = new TailingChangesPoller(poller, this.queue, this.tailSeconds);
            this.tailPoller.setDaemon(true);
            this.tailPoller.start();
        } else {
            this.tailPoller.setPollerTs(lastBatch.leftOffDate());
            Batch queuedBatch = (Batch)this.queue.poll();
            if (queuedBatch != null) {
                log.info("Merging {} changes from trailing queue", (Object)queuedBatch.changes().size());
                return lastBatch.merge(queuedBatch);
            }
        }
        return lastBatch;
    }

    private boolean changeIsRecent(Instant nextStartTime) {
        return nextStartTime.isAfter(Instant.now().minus(BACKOFF_THRESHOLD));
    }

    private RecentChangeResponse fetchRecentChanges(Instant lastNextStartTime, Batch lastBatch) throws RetryableException {
        try (Timer.Context timerContext = this.recentChangesTimer.time();){
            RecentChangeResponse recentChanges = this.doFetchRecentChanges(lastNextStartTime, lastBatch);
            this.recentChangesCounter.inc((long)recentChanges.getQuery().getRecentChanges().size());
            RecentChangeResponse recentChangeResponse = recentChanges;
            return recentChangeResponse;
        }
    }

    private RecentChangeResponse doFetchRecentChanges(Instant lastNextStartTime, Batch lastBatch) throws RetryableException {
        if (this.useBackoff && this.changeIsRecent(lastNextStartTime)) {
            return this.wikibase.fetchRecentChangesByTime(lastNextStartTime.minus(BACKOFF_TIME), this.batchSize);
        }
        return this.wikibase.fetchRecentChanges(lastNextStartTime, lastBatch != null ? lastBatch.getLastContinue() : null, this.batchSize);
    }

    private Batch batch(Instant lastNextStartTime, Batch lastBatch) throws RetryableException {
        boolean backoffOverflow;
        RecentChangeResponse recentChanges = this.fetchRecentChanges(lastNextStartTime, lastBatch);
        LinkedHashMap<String, Change> changesByTitle = new LinkedHashMap<String, Change>();
        Continue nextContinue = recentChanges.getContinue();
        Instant nextStartTime = lastNextStartTime;
        List<RecentChangeResponse.RecentChange> result = recentChanges.getQuery().getRecentChanges();
        for (RecentChangeResponse.RecentChange rc : result) {
            nextStartTime = Utils.max(nextStartTime, rc.getTimestamp());
            if (!this.wikibase.isEntityNamespace(rc.getNs())) {
                log.info("Skipping change in irrelevant namespace:  {}", (Object)rc);
                continue;
            }
            if (!this.wikibase.isValidEntity(rc.getTitle())) {
                log.info("Skipping change with bogus title:  {}", (Object)rc.getTitle());
                continue;
            }
            if (this.seenIDs.containsKey(rc.getRcId())) {
                log.debug("Skipping repeated change with rcid {}", (Object)rc.getRcId());
                continue;
            }
            this.seenIDs.put(rc.getRcId(), Boolean.TRUE);
            Change change = rc.getType().equals("log") && rc.getRevId() == 0L ? new Change(rc.getTitle(), -1L, rc.getTimestamp(), rc.getRcId()) : new Change(rc.getTitle(), rc.getRevId(), rc.getTimestamp(), rc.getRcId());
            Change dupe = changesByTitle.put(change.entityId(), change);
            if (dupe == null || dupe.revision() <= change.revision() && dupe.revision() >= 0L) continue;
            changesByTitle.remove(change.entityId());
            changesByTitle.put(change.entityId(), dupe);
        }
        ImmutableList changes = ImmutableList.copyOf(changesByTitle.values());
        boolean bl = backoffOverflow = this.useBackoff && changes.isEmpty() && result.size() >= this.batchSize;
        if (backoffOverflow) {
            nextStartTime = nextStartTime.plusSeconds(1L);
            log.info("Backoff overflow, advancing next time to {}", (Object)nextStartTime);
        }
        if (!changes.isEmpty()) {
            log.info("Got {} changes, from {} to {}", new Object[]{changes.size(), changes.get(0), changes.get(changes.size() - 1)});
        } else {
            log.info("Got no real changes");
        }
        long advanced = ChronoUnit.MILLIS.between(lastNextStartTime, nextStartTime);
        Batch batch = new Batch(changes, advanced, nextStartTime.minusSeconds(1L).toString(), nextStartTime, nextContinue);
        if (backoffOverflow && nextContinue != null) {
            log.info("Got only old changes, next is: {}", (Object)nextContinue);
            batch.hasChanges(true);
        }
        return batch;
    }

    @Override
    public void close() {
    }

    public static final class Batch
    extends Change.Batch.AbstractDefaultImplementation {
        private final Instant leftOffDate;
        private final Continue lastContinue;
        private boolean hasChanges;

        private Batch(ImmutableList<Change> changes, long advanced, String leftOff, Instant nextStartTime, Continue lastContinue) {
            super(changes, advanced, leftOff);
            this.leftOffDate = nextStartTime;
            this.lastContinue = lastContinue;
        }

        public void hasChanges(boolean changes) {
            this.hasChanges = changes;
        }

        @Override
        public boolean hasAnyChanges() {
            if (this.hasChanges) {
                return true;
            }
            return super.hasAnyChanges();
        }

        @Override
        public String advancedUnits() {
            return "milliseconds";
        }

        @Override
        public Instant leftOffDate() {
            return this.leftOffDate;
        }

        @Override
        public String leftOffHuman() {
            if (this.lastContinue != null) {
                return this.leftOffDate + " (next: " + this.lastContinue.getRcContinue() + ")";
            }
            return this.leftOffDate.toString();
        }

        @SuppressFBWarnings(value={"OCP_OVERLY_CONCRETE_PARAMETER"}, justification="Type seems semantically correct")
        public Batch merge(Batch another) {
            ImmutableList newChanges = new ImmutableList.Builder().addAll(another.changes()).addAll(this.changes()).build();
            return new Batch((ImmutableList<Change>)newChanges, this.advanced(), this.leftOffDate.toString(), this.leftOffDate, this.lastContinue);
        }

        public Continue getLastContinue() {
            return this.lastContinue;
        }
    }
}

