/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool.rdf;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.NumericLiteralImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.common.WikibasePoint;
import org.wikidata.query.rdf.common.uri.PropertyType;
import org.wikidata.query.rdf.common.uri.UrisScheme;
import org.wikidata.query.rdf.tool.change.Change;
import org.wikidata.query.rdf.tool.exception.ContainedException;
import org.wikidata.query.rdf.tool.rdf.PointCoordinateSwitcher;

public final class Munger {
    private static final Logger log = LoggerFactory.getLogger(Munger.class);
    private final UrisScheme uris;
    private final Set<String> limitLabelLanguages;
    private final List<String> singleLabelModeLanguages;
    private final boolean removeSiteLinks;
    private final boolean keepTypes;
    private String dumpFormatVersion;
    private static final Set<String> SKIPPED_TYPES = ImmutableSet.of((Object)"http://wikiba.se/ontology#Item", (Object)"http://wikiba.se/ontology#Lexeme", (Object)"http://wikiba.se/ontology#Form", (Object)"http://wikiba.se/ontology#Sense");
    private final Map<String, FormatHandler> formatHandlers;

    private Munger(UrisScheme uris, Set<String> limitLabelLanguages, List<String> singleLabelModeLanguages, boolean removeSiteLinks, boolean keepTypes, Map<String, FormatHandler> formatHandlers) {
        this.uris = uris;
        this.limitLabelLanguages = limitLabelLanguages;
        this.singleLabelModeLanguages = singleLabelModeLanguages;
        this.removeSiteLinks = removeSiteLinks;
        this.keepTypes = keepTypes;
        this.formatHandlers = formatHandlers;
    }

    public void setFormatVersion(String version) {
        this.dumpFormatVersion = version;
    }

    public Change munge(String entityId, Collection<Statement> statements, Collection<String> existingValues, Collection<String> existingRefs, Change sourceChange) {
        if (statements.isEmpty()) {
            return sourceChange;
        }
        MungeOperation op = new MungeOperation(entityId, statements, existingValues, existingRefs);
        if (sourceChange != null) {
            op.importFromChange(sourceChange);
        }
        op.munge();
        existingValues.removeAll(op.extraValidSubjects);
        existingRefs.removeAll(op.extraValidSubjects);
        return op.asChange();
    }

    public Change mungeWithValues(String entityId, Collection<Statement> statements, Multimap<String, String> repoValues, Multimap<String, String> repoRefs, Collection<String> valuesContainer, Collection<String> refsContainer, Change sourceChange) {
        valuesContainer.addAll(repoValues.get((Object)this.uris.entityIdToURI(entityId)));
        refsContainer.addAll(repoRefs.get((Object)this.uris.entityIdToURI(entityId)));
        return this.munge(entityId, statements, valuesContainer, refsContainer, sourceChange);
    }

    public Change munge(String entityId, Collection<Statement> statements) {
        return this.munge(entityId, statements, Collections.emptySet(), Collections.emptySet(), null);
    }

    public static Builder builder(UrisScheme uris) {
        return new Builder(uris);
    }

    public static class BadSubjectException
    extends ContainedException {
        private static final long serialVersionUID = -4869053066714948939L;

        public BadSubjectException(Set<String> badSubjects, UrisScheme uris) {
            super(String.format(Locale.ROOT, "Unrecognized subjects:  %s.  Expected only sitelinks and subjects starting with %s and %s", badSubjects, uris.entityData(), uris.entityURIs()));
        }
    }

    private class MungeOperation {
        private final String entityUri;
        private final Collection<Statement> statements;
        private final Resource entityUriImpl;
        private final List<Statement> restoredStatements = new ArrayList<Statement>();
        private final Set<String> subEntities = new HashSet<String>();
        private final Set<String> siteLinks = new HashSet<String>();
        private final Set<String> extraValidSubjects = new HashSet<String>();
        private final ListMultimap<String, Statement> unknownSubjects = ArrayListMultimap.create();
        private final SingleLabelModeWork singleLabelModeWorkForLabel;
        private final SingleLabelModeWork singleLabelModeWorkForDescription;
        private final Collection<String> existingValues;
        private final Collection<String> existingRefs;
        private final Set<Pair<URI, Literal>> dataStatements = new HashSet<Pair<URI, Literal>>();
        private Literal revisionId;
        private Literal lastModified;
        private FormatHandler formatHandler;
        private final Set<String> statementsWithoutRanks = new HashSet<String>();
        private final Set<String> statementsWithRanks = new HashSet<String>();
        private final String entityId;

        MungeOperation(String entityId, Collection<Statement> statements, Collection<String> existingValues, Collection<String> existingRefs) {
            this.statements = statements;
            this.entityId = entityId;
            this.entityUri = Munger.this.uris.entityIdToURI(entityId);
            this.entityUriImpl = new URIImpl(this.entityUri);
            if (Munger.this.singleLabelModeLanguages != null) {
                this.singleLabelModeWorkForLabel = new SingleLabelModeWork();
                this.singleLabelModeWorkForDescription = new SingleLabelModeWork();
            } else {
                this.singleLabelModeWorkForLabel = null;
                this.singleLabelModeWorkForDescription = null;
            }
            this.existingValues = existingValues;
            this.existingRefs = existingRefs;
            this.setFormatVersion(Munger.this.dumpFormatVersion);
        }

        private void setFormatVersion(String version) {
            this.formatHandler = (FormatHandler)Munger.this.formatHandlers.get(version);
        }

        public void importFromChange(Change sourceChange) {
            if (sourceChange.revision() > 0L) {
                this.revisionId = new NumericLiteralImpl(sourceChange.revision());
            }
            if (sourceChange.timestamp() != null) {
                this.lastModified = new LiteralImpl(sourceChange.timestamp().toString(), XMLSchema.DATETIME);
            }
        }

        public long getRevisionId() {
            return this.revisionId == null ? -1L : Long.parseLong(this.revisionId.stringValue());
        }

        public Instant getLastModified() {
            return Instant.parse(this.lastModified.stringValue());
        }

        public void munge() {
            Iterator<Statement> itr = this.statements.iterator();
            while (itr.hasNext()) {
                Statement shortStatement;
                Statement statement = itr.next();
                if (this.formatHandler != null) {
                    Statement handled = this.formatHandler.handle(statement);
                    if (handled == null) {
                        itr.remove();
                        continue;
                    }
                    if (!handled.equals((Object)statement)) {
                        itr.remove();
                        statement = handled;
                        if (this.statement(statement)) {
                            this.restoredStatements.add(statement);
                            continue;
                        }
                    }
                }
                if (!this.statement(statement)) {
                    itr.remove();
                }
                if ((shortStatement = this.checkObjectLength(statement)) == null) continue;
                itr.remove();
                this.restoredStatements.add(shortStatement);
            }
            this.finishSingleLabelMode();
            this.finishCommon();
        }

        private Statement checkObjectLength(Statement statement) {
            Literal value;
            if (statement.getObject() instanceof Literal && (value = (Literal)statement.getObject()).stringValue().length() > Short.MAX_VALUE) {
                LiteralImpl newValue = value.getDatatype().equals((Object)RDF.LANGSTRING) ? new LiteralImpl(value.stringValue().substring(0, Short.MAX_VALUE), value.getLanguage()) : new LiteralImpl(value.stringValue().substring(0, Short.MAX_VALUE), value.getDatatype());
                return new StatementImpl(statement.getSubject(), statement.getPredicate(), (Value)newValue);
            }
            return null;
        }

        private boolean statement(Statement statement) {
            String subject = statement.getSubject().stringValue();
            if (this.inNamespace(subject, Munger.this.uris.entityData()) || this.inNamespace(subject, Munger.this.uris.entityDataHttps())) {
                return this.entityDataStatement(statement);
            }
            if (this.inNamespace(subject, Munger.this.uris.statement())) {
                return this.entityStatementStatement(statement);
            }
            if (this.inNamespace(subject, Munger.this.uris.reference())) {
                return this.entityReferenceStatement(statement);
            }
            if (this.inNamespace(subject, Munger.this.uris.value())) {
                return this.entityValueStatement(statement);
            }
            if (Munger.this.uris.isEntityURI(subject)) {
                return this.entityStatement(statement);
            }
            if (subject.startsWith(Munger.this.uris.property(PropertyType.CLAIM))) {
                return this.propertyStatement(statement);
            }
            if (statement.getSubject() instanceof BNode) {
                return true;
            }
            return this.unknownStatement(statement);
        }

        private boolean inNamespace(String uri, String namespace) {
            return uri.startsWith(namespace) && uri.indexOf(47, namespace.length()) < 0;
        }

        private boolean propertyStatement(Statement statement) {
            if (statement.getSubject().stringValue().startsWith(Munger.this.uris.property(PropertyType.NOVALUE))) {
                return true;
            }
            return statement.getPredicate().stringValue().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        }

        private boolean entityDataStatement(Statement statement) {
            String predicate;
            boolean knownPredicate = false;
            switch (predicate = statement.getPredicate().stringValue()) {
                case "http://schema.org/version": {
                    knownPredicate = true;
                    this.revisionId = this.objectAsLiteral(statement);
                    break;
                }
                case "http://schema.org/dateModified": {
                    knownPredicate = true;
                    this.lastModified = this.objectAsLiteral(statement);
                    break;
                }
                case "http://schema.org/softwareVersion": {
                    this.setFormatVersion(this.objectAsLiteral(statement).stringValue());
                    break;
                }
                default: {
                    if (!predicate.startsWith("http://wikiba.se/ontology#")) break;
                    knownPredicate = true;
                }
            }
            if (knownPredicate) {
                this.dataStatements.add((Pair<URI, Literal>)new ImmutablePair((Object)statement.getPredicate(), (Object)this.objectAsLiteral(statement)));
            }
            return false;
        }

        private boolean entityStatement(Statement statement) {
            String subject = statement.getSubject().stringValue();
            if (!subject.equals(this.entityUri) && !this.subEntities.contains(subject)) {
                return false;
            }
            switch (statement.getPredicate().stringValue()) {
                case "http://www.w3.org/1999/02/22-rdf-syntax-ns#type": {
                    if (Munger.this.keepTypes) {
                        return true;
                    }
                    return !SKIPPED_TYPES.contains(statement.getObject().stringValue());
                }
                case "http://schema.org/name": 
                case "http://www.w3.org/2004/02/skos/core#prefLabel": {
                    return false;
                }
                case "http://www.w3.org/2000/01/rdf-schema#label": {
                    if (Munger.this.uris.entityURItoId(subject).startsWith("L") || this.subEntities.contains(subject)) {
                        return false;
                    }
                    return this.limitLabelLanguage(statement) && this.singleLabelMode(this.singleLabelModeWorkForLabel, statement);
                }
                case "http://schema.org/description": {
                    return this.limitLabelLanguage(statement) && this.singleLabelMode(this.singleLabelModeWorkForDescription, statement);
                }
                case "http://www.w3.org/2004/02/skos/core#altLabel": {
                    return this.limitLabelLanguage(statement);
                }
                case "http://www.w3.org/2002/07/owl#sameAs": {
                    return true;
                }
                case "http://www.w3.org/ns/lemon/ontolex#lexicalForm": 
                case "http://www.w3.org/ns/lemon/ontolex#sense": {
                    this.subEntities.add(statement.getObject().stringValue());
                    return true;
                }
            }
            return this.entityStatementWithUnrecognizedPredicate(statement);
        }

        private boolean entityStatementWithUnrecognizedPredicate(Statement statement) {
            String object = statement.getObject().stringValue();
            if (this.inNamespace(object, Munger.this.uris.statement())) {
                this.statementsWithoutRanks.add(object);
            }
            if (this.inNamespace(statement.getPredicate().stringValue(), Munger.this.uris.property(PropertyType.CLAIM)) && this.inNamespace(object, Munger.this.uris.statement())) {
                this.registerExtraValidSubject(object);
            }
            return true;
        }

        private boolean entityStatementStatement(Statement statement) {
            String subject = statement.getSubject().stringValue();
            switch (statement.getPredicate().stringValue()) {
                case "http://www.w3.org/1999/02/22-rdf-syntax-ns#type": {
                    this.statementsWithoutRanks.add(subject);
                    if (Munger.this.keepTypes) {
                        return true;
                    }
                    if (!statement.getObject().stringValue().equals("http://wikiba.se/ontology#Statement")) break;
                    return false;
                }
                case "http://www.w3.org/ns/prov#wasDerivedFrom": {
                    String object = statement.getObject().stringValue();
                    if (this.inNamespace(object, Munger.this.uris.reference())) {
                        this.registerExtraValidSubject(object);
                    }
                    return true;
                }
                case "http://wikiba.se/ontology#rank": {
                    this.statementsWithRanks.add(subject);
                    break;
                }
            }
            if (!this.extraValidSubjects.contains(subject)) {
                if (!statement.getPredicate().stringValue().equals("http://wikiba.se/ontology#hasViolationForConstraint")) {
                    this.unknownSubjects.put((Object)subject, (Object)statement);
                }
                return false;
            }
            String object = statement.getObject().stringValue();
            if (this.inNamespace(object, Munger.this.uris.value())) {
                this.registerExtraValidSubject(object);
            }
            return true;
        }

        private boolean tripleRefValue(Statement statement) {
            String predicate = statement.getPredicate().stringValue();
            String object = statement.getObject().stringValue();
            if (!this.inNamespace(object, Munger.this.uris.value())) {
                return false;
            }
            return this.inNamespace(predicate, Munger.this.uris.property(PropertyType.REFERENCE_VALUE)) || this.inNamespace(predicate, Munger.this.uris.property(PropertyType.REFERENCE_VALUE_NORMALIZED));
        }

        private boolean entityReferenceStatement(Statement statement) {
            String object = statement.getObject().stringValue();
            String subject = statement.getSubject().stringValue();
            if (this.existingRefs.contains(subject) && this.tripleRefValue(statement) && !this.existingValues.contains(object)) {
                this.registerExtraValidSubject(object);
                log.info("Weird reference {}: unknown value {} for {}", new Object[]{subject, object, this.entityUri});
            }
            if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#type".equals(statement.getPredicate().stringValue())) {
                if (Munger.this.keepTypes) {
                    return true;
                }
                if (statement.getObject().stringValue().equals("http://wikiba.se/ontology#Reference")) {
                    return false;
                }
            }
            if (!this.extraValidSubjects.contains(subject)) {
                this.unknownSubjects.put((Object)subject, (Object)statement);
                return false;
            }
            if (this.tripleRefValue(statement)) {
                this.registerExtraValidSubject(object);
            }
            return true;
        }

        private boolean entityValueStatement(Statement statement) {
            String subject = statement.getSubject().stringValue();
            if (this.existingValues.contains(subject)) {
                return false;
            }
            switch (statement.getPredicate().stringValue()) {
                case "http://www.w3.org/1999/02/22-rdf-syntax-ns#type": {
                    if (Munger.this.keepTypes) {
                        return true;
                    }
                    if (!statement.getObject().stringValue().equals("http://wikiba.se/ontology#Value")) break;
                    return false;
                }
                case "http://wikiba.se/ontology#quantityNormalized": {
                    this.registerExtraValidSubject(statement.getObject().stringValue());
                    break;
                }
            }
            if (!this.extraValidSubjects.contains(subject)) {
                this.unknownSubjects.put((Object)subject, (Object)statement);
                return false;
            }
            return true;
        }

        private boolean unknownStatement(Statement statement) {
            String predicate = statement.getPredicate().stringValue();
            String subject = statement.getSubject().stringValue();
            if (predicate.equals("http://wikiba.se/ontology#wikiGroup")) {
                return true;
            }
            if (this.siteLinks.contains(subject)) {
                return !Munger.this.removeSiteLinks;
            }
            if (this.extraValidSubjects.contains(subject)) {
                return true;
            }
            if (predicate.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type") && statement.getObject().stringValue().equals("http://schema.org/Article")) {
                this.siteLinks.add(subject);
                if (Munger.this.removeSiteLinks) {
                    this.unknownSubjects.removeAll((Object)subject);
                    return false;
                }
                this.restoredStatements.addAll(this.unknownSubjects.removeAll((Object)subject));
                return true;
            }
            this.unknownSubjects.put((Object)subject, (Object)statement);
            return false;
        }

        private boolean limitLabelLanguage(Statement statement) {
            if (Munger.this.limitLabelLanguages == null) {
                return true;
            }
            Literal object = this.objectAsLiteral(statement);
            String language = object.getLanguage();
            return language != null && Munger.this.limitLabelLanguages.contains(language);
        }

        private boolean singleLabelMode(SingleLabelModeWork work, Statement statement) {
            return work == null || work.statement(statement);
        }

        private void finishCommon() {
            if (!this.unknownSubjects.isEmpty()) {
                if (this.statements.isEmpty() && this.restoredStatements.isEmpty()) {
                    throw new BadSubjectException(this.unknownSubjects.keySet(), Munger.this.uris);
                }
                log.info("Unrecognized subjects: {} while processing {}.  Expected only sitelinks and subjects starting with {} and {}", new Object[]{this.unknownSubjects.keySet(), this.entityUri, Munger.this.uris.entityData(), Munger.this.uris.entityURIs()});
                this.unknownSubjects.entries().stream().limit(20L).forEach(e -> log.info("Unrecognized statement: s:{} p:{} o:{}", new Object[]{((Statement)e.getValue()).getSubject(), ((Statement)e.getValue()).getPredicate(), ((Statement)e.getValue()).getObject()}));
                if (this.unknownSubjects.size() > 20) {
                    log.info("More than 20 unrecognized statements, further statements not logged.");
                }
            }
            this.statementsWithoutRanks.removeAll(this.statementsWithRanks);
            if (!this.statementsWithoutRanks.isEmpty()) {
                log.error("Found some statements without ranks while processing {}: {}", (Object)this.entityUri, this.statementsWithoutRanks);
            }
            if (this.revisionId == null) {
                throw new ContainedException("Didn't get a revision id for " + this.statements);
            }
            if (this.lastModified == null) {
                throw new ContainedException("Didn't get a last modified date for " + this.statements);
            }
            for (Pair<URI, Literal> dataStatement : this.dataStatements) {
                this.statements.add((Statement)new StatementImpl(this.entityUriImpl, (URI)dataStatement.getLeft(), (Value)dataStatement.getRight()));
            }
            this.statements.addAll(this.restoredStatements);
        }

        private void finishSingleLabelMode() {
            if (Munger.this.singleLabelModeLanguages != null) {
                this.singleLabelModeWorkForLabel.addBestStatement(this.statements);
                this.singleLabelModeWorkForDescription.addBestStatement(this.statements);
            }
        }

        private void registerExtraValidSubject(String subject) {
            this.extraValidSubjects.add(subject);
            this.restoredStatements.addAll(this.unknownSubjects.removeAll((Object)subject));
        }

        @SuppressFBWarnings(value={"LEST_LOST_EXCEPTION_STACK_TRACE"}, justification="Cause is really not needed here.")
        private Literal objectAsLiteral(Statement statement) {
            try {
                return (Literal)statement.getObject();
            }
            catch (ClassCastException e) {
                throw new ContainedException("Expected Literal in object position of:  " + statement);
            }
        }

        private Change asChange() {
            return new Change(this.entityId, this.getRevisionId(), this.getLastModified(), 0L);
        }

        private class SingleLabelModeWork {
            private Statement bestStatement;
            private int bestIndex = -1;

            private SingleLabelModeWork() {
            }

            public boolean statement(Statement statement) {
                Literal object = MungeOperation.this.objectAsLiteral(statement);
                String language = object.getLanguage();
                int index = Munger.this.singleLabelModeLanguages.indexOf(language);
                if (index > this.bestIndex) {
                    this.bestStatement = statement;
                    this.bestIndex = index;
                }
                return false;
            }

            public void addBestStatement(Collection<Statement> statements) {
                if (this.bestStatement != null) {
                    statements.add(this.bestStatement);
                }
            }
        }
    }

    public static interface FormatHandler {
        public Statement handle(Statement var1);
    }

    public static final class Builder {
        private UrisScheme uris;
        private Collection<String> limitLabelLanguages;
        private List<String> singleLabelModeLanguages;
        private boolean removeSiteLinks;
        private boolean keepTypes;
        private Map<String, FormatHandler> formatHandlers = new HashMap<String, FormatHandler>();

        Builder(UrisScheme uris) {
            this.uris = uris;
            if (WikibasePoint.DEFAULT_ORDER == WikibasePoint.CoordinateOrder.LAT_LONG) {
                this.addFormatHandler("0.0.2", new PointCoordinateSwitcher());
            } else {
                this.addFormatHandler("0.0.1", new PointCoordinateSwitcher());
            }
        }

        public Builder removeSiteLinks() {
            this.removeSiteLinks = true;
            return this;
        }

        public Builder limitLabelLanguages(String ... languages) {
            return this.limitLabelLanguages(Arrays.asList(languages));
        }

        public Builder limitLabelLanguages(Collection<String> languages) {
            this.limitLabelLanguages = languages;
            return this;
        }

        public Builder singleLabelMode(String ... languages) {
            return this.singleLabelMode(Arrays.asList(languages));
        }

        public Builder singleLabelMode(List<String> languages) {
            this.singleLabelModeLanguages = languages;
            return this;
        }

        public Builder keepTypes(boolean keep) {
            this.keepTypes = keep;
            return this;
        }

        @VisibleForTesting
        Builder addFormatHandler(String version, FormatHandler handler) {
            this.formatHandlers.put(version, handler);
            return this;
        }

        public Munger build() {
            return new Munger(this.uris, (Set)(this.limitLabelLanguages == null ? null : ImmutableSet.copyOf(this.limitLabelLanguages)), (List)(this.singleLabelModeLanguages == null ? null : ImmutableList.copyOf(this.singleLabelModeLanguages).reverse()), this.removeSiteLinks, this.keepTypes, (Map)ImmutableMap.copyOf(this.formatHandlers));
        }
    }
}

