/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool.rdf.client;

import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.FormContentProvider;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.util.Fields;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.common.uri.UrisScheme;
import org.wikidata.query.rdf.tool.exception.ContainedException;
import org.wikidata.query.rdf.tool.exception.FatalException;
import org.wikidata.query.rdf.tool.rdf.client.AskQueryResponse;
import org.wikidata.query.rdf.tool.rdf.client.ResponseHandler;
import org.wikidata.query.rdf.tool.rdf.client.TupleQueryResponse;
import org.wikidata.query.rdf.tool.rdf.client.UpdateCountResponse;

public class RdfClient {
    private static final Logger log = LoggerFactory.getLogger(RdfClient.class);
    private static final ResponseHandler<Integer> UPDATE_COUNT_RESPONSE = new UpdateCountResponse();
    private static final ResponseHandler<TupleQueryResult> TUPLE_QUERY_RESPONSE = new TupleQueryResponse();
    private static final ResponseHandler<Boolean> ASK_QUERY_RESPONSE = new AskQueryResponse();
    @VisibleForTesting
    public final HttpClient httpClient;
    private final URI uri;
    private final Duration timeout;
    private final Retryer<ContentResponse> retryer;

    public RdfClient(HttpClient httpClient, URI uri, Retryer<ContentResponse> retryer, Duration timeout) {
        this.httpClient = httpClient;
        this.uri = uri;
        this.timeout = timeout;
        this.retryer = retryer;
    }

    public TupleQueryResult query(String sparql) {
        return this.execute("query", TUPLE_QUERY_RESPONSE, sparql);
    }

    public Integer update(String sparql) {
        return this.execute("update", UPDATE_COUNT_RESPONSE, sparql);
    }

    public boolean ask(String sparql) {
        return this.execute("query", ASK_QUERY_RESPONSE, sparql);
    }

    @VisibleForTesting
    public Integer loadUrl(String sparql) {
        return this.execute("uri", UPDATE_COUNT_RESPONSE, sparql);
    }

    private <T> T execute(String type, ResponseHandler<T> responseHandler, String sparql) {
        log.trace("Running SPARQL: [{}] {}", (Object)sparql.length(), (Object)sparql);
        long startQuery = System.currentTimeMillis();
        try {
            ContentResponse response = (ContentResponse)this.retryer.call(() -> this.makeRequest(type, sparql, responseHandler.acceptHeader()).send());
            if (response.getStatus() != 200) {
                throw new ContainedException("Non-200 response from triple store:  " + response + " body=\n" + response.getContentAsString());
            }
            log.debug("Completed in {} ms", (Object)(System.currentTimeMillis() - startQuery));
            return responseHandler.parse(response);
        }
        catch (RetryException | IOException | ExecutionException e) {
            throw new FatalException("Error accessing triple store", e);
        }
    }

    private Request makeRequest(@Nonnull String type, @Nonnull String sparql, @Nullable String accept) {
        Request post = this.httpClient.newRequest(this.uri);
        post.method(HttpMethod.POST);
        if (!this.timeout.isNegative()) {
            post.timeout(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        if (accept != null) {
            post.header("Accept", accept);
        }
        if (type.equals("update")) {
            post.content((ContentProvider)new StringContentProvider("application/sparql-update; charset=UTF-8", sparql, StandardCharsets.UTF_8));
        } else {
            Fields fields = new Fields();
            fields.add(type, sparql);
            FormContentProvider form = new FormContentProvider(fields, StandardCharsets.UTF_8);
            post.content((ContentProvider)form);
        }
        return post;
    }

    public ImmutableSetMultimap<String, String> selectToMap(String query, String keyBinding, String valueBinding) {
        return this.resultToMap(this.query(query), keyBinding, valueBinding);
    }

    private ImmutableSetMultimap<String, String> resultToMap(TupleQueryResult result, String keyBinding, String valueBinding) {
        ImmutableSetMultimap.Builder values = ImmutableSetMultimap.builder();
        try {
            while (result.hasNext()) {
                BindingSet bindings = (BindingSet)result.next();
                Binding value = bindings.getBinding(valueBinding);
                Binding key = bindings.getBinding(keyBinding);
                if (value == null || key == null) continue;
                values.put((Object)key.getValue().stringValue(), (Object)value.getValue().stringValue());
            }
        }
        catch (QueryEvaluationException e) {
            throw new FatalException("Can't load results: " + (Object)((Object)e), e);
        }
        return values.build();
    }

    public List<String> getEntityIds(String query, String valueBinding, UrisScheme uris) {
        return this.resultToList(this.query(query), valueBinding, arg_0 -> ((UrisScheme)uris).entityURItoId(arg_0));
    }

    private List<String> resultToList(TupleQueryResult result, String valueBinding, Function<String, String> transform) {
        ImmutableList.Builder values = ImmutableList.builder();
        try {
            while (result.hasNext()) {
                BindingSet bindings = (BindingSet)result.next();
                Binding value = bindings.getBinding(valueBinding);
                if (value == null) continue;
                values.add((Object)transform.apply(value.getValue().stringValue()));
            }
        }
        catch (QueryEvaluationException e) {
            throw new FatalException("Can't load results: " + (Object)((Object)e), e);
        }
        return values.build();
    }
}

