/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool.utils;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.commons.io.input.TeeInputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.tool.utils.StreamDumper;

public class FileStreamDumper
implements StreamDumper {
    private static final Logger log = LoggerFactory.getLogger(FileStreamDumper.class);
    private static final String DUMP_FILE_SUFFIX = ".dump";
    private final Path dumpDir;
    public final Duration keepDumpsDuration;
    private final Clock clock;
    private OutputStream dumpOutput;
    private final AtomicLong numberOfRotations = new AtomicLong();

    public FileStreamDumper(Path dumpDir) {
        this(dumpDir, Clock.systemUTC(), Duration.of(1L, ChronoUnit.HOURS));
    }

    public FileStreamDumper(Path dumpDir, Clock clock, Duration keepDumpsDuration) {
        this.dumpDir = dumpDir;
        this.clock = clock;
        this.dumpOutput = this.createDumpFile();
        this.keepDumpsDuration = keepDumpsDuration;
    }

    @Override
    public InputStream wrap(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        FilterOutputStream tee = new FilterOutputStream(buffer){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                FileStreamDumper fileStreamDumper = FileStreamDumper.this;
                synchronized (fileStreamDumper) {
                    FileStreamDumper.this.dumpOutput.write(buffer.toByteArray());
                }
                super.close();
            }
        };
        return new TeeInputStream(inputStream, (OutputStream)tee, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rotate() {
        FileStreamDumper fileStreamDumper = this;
        synchronized (fileStreamDumper) {
            this.closeCurrentOutput();
            this.dumpOutput = this.createDumpFile();
        }
        if (this.numberOfRotations.incrementAndGet() % 20L == 0L) {
            this.cleanDumps();
        }
    }

    @VisibleForTesting
    synchronized void flush() throws IOException {
        this.dumpOutput.flush();
    }

    private void closeCurrentOutput() {
        try {
            this.dumpOutput.close();
        }
        catch (IOException ioe) {
            log.info("Could not close dump file, some data might be lost", (Throwable)ioe);
        }
    }

    private OutputStream createDumpFile() {
        try {
            long timestamp = this.clock.millis();
            Path dumpFile = this.dumpDir.resolve(String.valueOf(timestamp) + DUMP_FILE_SUFFIX);
            return new BufferedOutputStream(Files.newOutputStream(dumpFile, StandardOpenOption.CREATE));
        }
        catch (IOException ioe) {
            log.info("Could not create dump file, dump will be ignored.");
            return new NullOutputStream();
        }
    }

    private void cleanDumps() {
        Instant cutoff = Instant.now(this.clock).minus(this.keepDumpsDuration);
        try (Stream<Path> dumpFiles = Files.list(this.dumpDir);){
            dumpFiles.filter(p -> {
                try {
                    return p.toString().endsWith(DUMP_FILE_SUFFIX) && Files.getLastModifiedTime(p, new LinkOption[0]).toInstant().isBefore(cutoff);
                }
                catch (IOException e) {
                    return false;
                }
            }).forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (IOException e) {
                    log.info("Could not delete {}.", p);
                }
            });
        }
        catch (IOException e) {
            log.info("Could not list files in {}", (Object)this.dumpDir, (Object)e);
        }
    }
}

