/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.a2a.server.apps.jakarta;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.a2a.server.ExtendedAgentCard;
import io.a2a.server.ServerCallContext;
import io.a2a.server.auth.UnauthenticatedUser;
import io.a2a.server.auth.User;
import io.a2a.server.util.async.Internal;
import io.a2a.spec.AgentCard;
import io.a2a.spec.CancelTaskRequest;
import io.a2a.spec.DeleteTaskPushNotificationConfigRequest;
import io.a2a.spec.GetAuthenticatedExtendedCardRequest;
import io.a2a.spec.GetTaskPushNotificationConfigRequest;
import io.a2a.spec.GetTaskRequest;
import io.a2a.spec.IdJsonMappingException;
import io.a2a.spec.InvalidParamsError;
import io.a2a.spec.InvalidParamsJsonMappingException;
import io.a2a.spec.InvalidRequestError;
import io.a2a.spec.JSONParseError;
import io.a2a.spec.JSONRPCError;
import io.a2a.spec.JSONRPCErrorResponse;
import io.a2a.spec.JSONRPCRequest;
import io.a2a.spec.JSONRPCResponse;
import io.a2a.spec.ListTaskPushNotificationConfigRequest;
import io.a2a.spec.MethodNotFoundError;
import io.a2a.spec.MethodNotFoundJsonMappingException;
import io.a2a.spec.NonStreamingJSONRPCRequest;
import io.a2a.spec.SendMessageRequest;
import io.a2a.spec.SendStreamingMessageRequest;
import io.a2a.spec.SetTaskPushNotificationConfigRequest;
import io.a2a.spec.StreamingJSONRPCRequest;
import io.a2a.spec.TaskResubscriptionRequest;
import io.a2a.spec.UnsupportedOperationError;
import io.a2a.transport.jsonrpc.handler.JSONRPCHandler;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extras.a2a.server.apps.jakarta.CallContextFactory;

@Path(value="/")
public class A2AServerResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(A2AServerResource.class);
    @Inject
    JSONRPCHandler jsonRpcHandler;
    @Inject
    @ExtendedAgentCard
    Instance<AgentCard> extendedAgentCard;
    private static volatile Runnable streamingIsSubscribedRunnable;
    @Inject
    @Internal
    Executor executor;
    @Inject
    Instance<CallContextFactory> callContextFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JSONRPCResponse<?> handleNonStreamingRequests(NonStreamingJSONRPCRequest<?> request, @Context HttpServletRequest httpRequest, @Context SecurityContext securityContext) {
        ServerCallContext context = this.createCallContext(httpRequest, securityContext);
        LOGGER.debug("Handling non-streaming request");
        try {
            JSONRPCResponse<?> jSONRPCResponse = this.processNonStreamingRequest(request, context);
            return jSONRPCResponse;
        }
        finally {
            LOGGER.debug("Completed non-streaming request");
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/event-stream"})
    public void handleStreamingRequests(StreamingJSONRPCRequest<?> request, @Context HttpServletResponse response, @Context HttpServletRequest httpRequest, @Context SecurityContext securityContext, @Context Providers providers) throws IOException {
        ServerCallContext context = this.createCallContext(httpRequest, securityContext);
        LOGGER.debug("Handling streaming request with custom SSE response");
        response.setContentType("text/event-stream");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Cache-Control", "no-cache");
        ObjectMapper objectMapper = (ObjectMapper)providers.getContextResolver(ObjectMapper.class, MediaType.APPLICATION_JSON_TYPE).getContext(JSONRPCResponse.class);
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
            objectMapper.registerModule((Module)new JavaTimeModule());
            objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        }
        Flow.Publisher<? extends JSONRPCResponse<?>> publisher = this.createStreamingPublisher(request, context);
        LOGGER.debug("Created streaming publisher: {}", publisher);
        if (publisher != null) {
            LOGGER.debug("Handling custom SSE response for publisher: {}", publisher);
            this.handleCustomSSEResponse(publisher, response, objectMapper);
        } else {
            LOGGER.debug("Unsupported streaming request type: {}", (Object)request.getClass().getSimpleName());
            response.sendError(400, "Unsupported streaming request type");
        }
        LOGGER.debug("Completed streaming request processing");
    }

    @GET
    @Path(value="/.well-known/agent-card.json")
    @Produces(value={"application/json"})
    public AgentCard getAgentCard() {
        return this.jsonRpcHandler.getAgentCard();
    }

    private JSONRPCResponse<?> processNonStreamingRequest(NonStreamingJSONRPCRequest<?> request, ServerCallContext context) {
        if (request instanceof GetTaskRequest) {
            GetTaskRequest req = (GetTaskRequest)request;
            return this.jsonRpcHandler.onGetTask(req, context);
        }
        if (request instanceof CancelTaskRequest) {
            CancelTaskRequest req = (CancelTaskRequest)request;
            return this.jsonRpcHandler.onCancelTask(req, context);
        }
        if (request instanceof SetTaskPushNotificationConfigRequest) {
            SetTaskPushNotificationConfigRequest req = (SetTaskPushNotificationConfigRequest)request;
            return this.jsonRpcHandler.setPushNotificationConfig(req, context);
        }
        if (request instanceof GetTaskPushNotificationConfigRequest) {
            GetTaskPushNotificationConfigRequest req = (GetTaskPushNotificationConfigRequest)request;
            return this.jsonRpcHandler.getPushNotificationConfig(req, context);
        }
        if (request instanceof SendMessageRequest) {
            SendMessageRequest req = (SendMessageRequest)request;
            return this.jsonRpcHandler.onMessageSend(req, context);
        }
        if (request instanceof ListTaskPushNotificationConfigRequest) {
            ListTaskPushNotificationConfigRequest req = (ListTaskPushNotificationConfigRequest)request;
            return this.jsonRpcHandler.listPushNotificationConfig(req, context);
        }
        if (request instanceof DeleteTaskPushNotificationConfigRequest) {
            DeleteTaskPushNotificationConfigRequest req = (DeleteTaskPushNotificationConfigRequest)request;
            return this.jsonRpcHandler.deletePushNotificationConfig(req, context);
        }
        if (request instanceof GetAuthenticatedExtendedCardRequest) {
            GetAuthenticatedExtendedCardRequest req = (GetAuthenticatedExtendedCardRequest)request;
            return this.jsonRpcHandler.onGetAuthenticatedExtendedCardRequest(req, context);
        }
        return this.generateErrorResponse((JSONRPCRequest<?>)request, (JSONRPCError)new UnsupportedOperationError());
    }

    private Flow.Publisher<? extends JSONRPCResponse<?>> createStreamingPublisher(StreamingJSONRPCRequest<?> request, ServerCallContext context) {
        if (request instanceof SendStreamingMessageRequest) {
            SendStreamingMessageRequest req = (SendStreamingMessageRequest)request;
            return this.jsonRpcHandler.onMessageSendStream(req, context);
        }
        if (request instanceof TaskResubscriptionRequest) {
            TaskResubscriptionRequest req = (TaskResubscriptionRequest)request;
            return this.jsonRpcHandler.onResubscribeToTask(req, context);
        }
        return null;
    }

    private void handleCustomSSEResponse(Flow.Publisher<? extends JSONRPCResponse<?>> publisher, HttpServletResponse response, final ObjectMapper objectMapper) throws IOException {
        final PrintWriter writer = response.getWriter();
        final AtomicLong eventId = new AtomicLong(0L);
        final CompletableFuture streamingComplete = new CompletableFuture();
        publisher.subscribe(new Flow.Subscriber<JSONRPCResponse<?>>(){
            private Flow.Subscription subscription;

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                LOGGER.debug("Custom SSE subscriber onSubscribe called");
                this.subscription = subscription;
                subscription.request(Long.MAX_VALUE);
                Runnable runnable = streamingIsSubscribedRunnable;
                if (runnable != null) {
                    runnable.run();
                }
            }

            @Override
            public void onNext(JSONRPCResponse<?> item) {
                LOGGER.debug("Custom SSE subscriber onNext called with item: {}", item);
                try {
                    String jsonData = objectMapper.writeValueAsString(item);
                    long id = eventId.getAndIncrement();
                    writer.write("data: " + jsonData + "\n");
                    writer.write("id: " + id + "\n");
                    writer.write("\n");
                    writer.flush();
                    LOGGER.debug("Custom SSE event sent successfully with id: {}", (Object)id);
                }
                catch (Exception e) {
                    LOGGER.error("Error writing SSE event: {}", (Object)e.getMessage(), (Object)e);
                    this.onError(e);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                LOGGER.debug("Custom SSE subscriber onError called: {}", (Object)throwable.getMessage(), (Object)throwable);
                try {
                    writer.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error closing writer: {}", (Object)e.getMessage(), (Object)e);
                }
                streamingComplete.completeExceptionally(throwable);
            }

            @Override
            public void onComplete() {
                LOGGER.debug("Custom SSE subscriber onComplete called");
                try {
                    writer.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error closing writer: {}", (Object)e.getMessage(), (Object)e);
                }
                streamingComplete.complete(null);
            }
        });
        try {
            streamingComplete.get();
        }
        catch (Exception e) {
            LOGGER.error("Error waiting for streaming completion: {}", (Object)e.getMessage(), (Object)e);
            throw new IOException("Streaming failed", e);
        }
    }

    private JSONRPCResponse<?> generateErrorResponse(JSONRPCRequest<?> request, JSONRPCError error) {
        return new JSONRPCErrorResponse(request.getId(), error);
    }

    public static void setStreamingIsSubscribedRunnable(Runnable streamingIsSubscribedRunnable) {
        A2AServerResource.streamingIsSubscribedRunnable = streamingIsSubscribedRunnable;
    }

    private ServerCallContext createCallContext(HttpServletRequest request, final SecurityContext securityContext) {
        if (this.callContextFactory.isUnsatisfied()) {
            Object user = securityContext.getUserPrincipal() == null ? UnauthenticatedUser.INSTANCE : new User(){

                public boolean isAuthenticated() {
                    return true;
                }

                public String getUsername() {
                    return securityContext.getUserPrincipal().getName();
                }
            };
            HashMap state = new HashMap();
            HashMap<String, String> headers = new HashMap<String, String>();
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                headers.put(name, (String)headers.get(name));
            }
            state.put("headers", headers);
            return new ServerCallContext((User)user, state);
        }
        CallContextFactory builder = (CallContextFactory)this.callContextFactory.get();
        return builder.build(request);
    }

    @Provider
    public static class JsonMappingExceptionMapper
    implements ExceptionMapper<JsonMappingException> {
        public Response toResponse(JsonMappingException exception) {
            if (exception.getCause() instanceof JsonParseException) {
                return Response.ok((Object)new JSONRPCErrorResponse((JSONRPCError)new JSONParseError())).type("application/json").build();
            }
            if (exception instanceof MethodNotFoundJsonMappingException) {
                Object id = ((MethodNotFoundJsonMappingException)exception).getId();
                return Response.ok((Object)new JSONRPCErrorResponse(id, (JSONRPCError)new MethodNotFoundError())).type("application/json").build();
            }
            if (exception instanceof InvalidParamsJsonMappingException) {
                Object id = ((InvalidParamsJsonMappingException)exception).getId();
                return Response.ok((Object)new JSONRPCErrorResponse(id, (JSONRPCError)new InvalidParamsError())).type("application/json").build();
            }
            if (exception instanceof IdJsonMappingException) {
                Object id = ((IdJsonMappingException)exception).getId();
                return Response.ok((Object)new JSONRPCErrorResponse(id, (JSONRPCError)new InvalidRequestError())).type("application/json").build();
            }
            return Response.ok((Object)new JSONRPCErrorResponse((JSONRPCError)new InvalidRequestError())).type("application/json").build();
        }
    }

    @Provider
    public static class JsonParseExceptionMapper
    implements ExceptionMapper<JsonParseException> {
        public Response toResponse(JsonParseException exception) {
            return Response.ok((Object)new JSONRPCErrorResponse((JSONRPCError)new JSONParseError())).type("application/json").build();
        }
    }
}

