/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.a2a.server.apps.rest;

import io.a2a.server.ExtendedAgentCard;
import io.a2a.server.ServerCallContext;
import io.a2a.server.auth.UnauthenticatedUser;
import io.a2a.server.auth.User;
import io.a2a.server.util.async.Internal;
import io.a2a.spec.AgentCard;
import io.a2a.spec.InternalError;
import io.a2a.spec.InvalidParamsError;
import io.a2a.spec.JSONRPCError;
import io.a2a.transport.rest.handler.RestHandler;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extras.a2a.server.apps.rest.CallContextFactory;
import org.wildfly.extras.a2a.server.apps.rest.SSESubscriber;

@Path(value="/")
public class A2ARestServerResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(A2ARestServerResource.class);
    @Inject
    RestHandler jsonRestHandler;
    @Inject
    @ExtendedAgentCard
    Instance<AgentCard> extendedAgentCard;
    private static volatile Runnable streamingIsSubscribedRunnable;
    @Inject
    @Internal
    Executor executor;
    @Inject
    Instance<CallContextFactory> callContextFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="v1/message:send")
    public Response sendMessage(String body, @Context HttpServletRequest httpRequest, @Context SecurityContext securityContext) {
        ServerCallContext context = this.createCallContext(httpRequest, securityContext);
        RestHandler.HTTPRestResponse response = null;
        try {
            response = this.jsonRestHandler.sendMessage(body, context);
            return response;
        }
        catch (Throwable t) {
            response = this.jsonRestHandler.createErrorResponse((JSONRPCError)new InternalError(t.getMessage()));
            return response;
        }
        finally {
            return Response.status((int)response.getStatusCode()).header("Content-Type", (Object)response.getContentType()).entity((Object)response.getBody()).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/event-stream"})
    @Path(value="v1/message:stream")
    public void sendMessageStreaming(String body, @Context HttpServletRequest httpRequest, @Context HttpServletResponse httpResponse, @Context SecurityContext securityContext) throws IOException {
        ServerCallContext context = this.createCallContext(httpRequest, securityContext);
        RestHandler.HTTPRestStreamingResponse streamingResponse = null;
        RestHandler.HTTPRestResponse error = null;
        try {
            RestHandler.HTTPRestResponse response = this.jsonRestHandler.sendStreamingMessage(body, context);
            if (response instanceof RestHandler.HTTPRestStreamingResponse) {
                RestHandler.HTTPRestStreamingResponse hTTPRestStreamingResponse;
                streamingResponse = hTTPRestStreamingResponse = (RestHandler.HTTPRestStreamingResponse)response;
            } else {
                error = response;
            }
        }
        finally {
            if (error != null) {
                httpResponse.setHeader("Content-Type", "application/json");
                httpResponse.sendError(error.getStatusCode(), error.getBody());
            } else {
                this.handleCustomSSEResponse(streamingResponse.getPublisher(), httpResponse);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/event-stream"})
    @Path(value="v1/tasks/{taskId}:subscribe")
    public void resubscribeTask(@PathParam(value="taskId") String taskId, @Context HttpServletRequest httpRequest, @Context HttpServletResponse httpResponse, @Context SecurityContext securityContext) throws IOException {
        ServerCallContext context = this.createCallContext(httpRequest, securityContext);
        RestHandler.HTTPRestStreamingResponse streamingResponse = null;
        RestHandler.HTTPRestResponse error = null;
        try {
            RestHandler.HTTPRestResponse response = this.jsonRestHandler.resubscribeTask(taskId, context);
            if (response instanceof RestHandler.HTTPRestStreamingResponse) {
                RestHandler.HTTPRestStreamingResponse hTTPRestStreamingResponse;
                streamingResponse = hTTPRestStreamingResponse = (RestHandler.HTTPRestStreamingResponse)response;
            } else {
                error = response;
            }
        }
        finally {
            if (error != null) {
                httpResponse.setHeader("Content-Type", "application/json");
                httpResponse.sendError(error.getStatusCode(), error.getBody());
            } else {
                this.handleCustomSSEResponse(streamingResponse.getPublisher(), httpResponse);
            }
        }
    }

    @GET
    @Path(value=".well-known/agent-card.json")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAgentCard() {
        RestHandler.HTTPRestResponse response = this.jsonRestHandler.getAgentCard();
        return Response.status((int)response.getStatusCode()).header("Content-Type", (Object)response.getContentType()).entity((Object)response.getBody()).build();
    }

    @GET
    @Path(value="v1/card")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAuthenticatedExtendedCard() {
        RestHandler.HTTPRestResponse response = this.jsonRestHandler.getAuthenticatedExtendedCard();
        return Response.status((int)response.getStatusCode()).header("Content-Type", (Object)response.getContentType()).entity((Object)response.getBody()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="v1/tasks/{taskId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getTask(@PathParam(value="taskId") String taskId, @QueryParam(value="history_length") String history_length, @Context HttpServletRequest httpRequest, @Context SecurityContext securityContext) {
        ServerCallContext context = this.createCallContext(httpRequest, securityContext);
        RestHandler.HTTPRestResponse response = null;
        try {
            Integer historyLength = null;
            if (history_length != null) {
                historyLength = Integer.valueOf(history_length);
            }
            response = this.jsonRestHandler.getTask(taskId, historyLength, context);
            return response;
        }
        catch (NumberFormatException e) {
            response = this.jsonRestHandler.createErrorResponse((JSONRPCError)new InvalidParamsError("bad history_length"));
            return response;
        }
        catch (Throwable t) {
            response = this.jsonRestHandler.createErrorResponse((JSONRPCError)new InternalError(t.getMessage()));
            return response;
        }
        finally {
            return Response.status((int)response.getStatusCode()).header("Content-Type", (Object)response.getContentType()).entity((Object)response.getBody()).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="v1/tasks/{taskId}:cancel")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response cancelTask(@PathParam(value="taskId") String taskId, String body, @Context HttpServletRequest httpRequest, @Context SecurityContext securityContext) {
        ServerCallContext context = this.createCallContext(httpRequest, securityContext);
        RestHandler.HTTPRestResponse response = null;
        try {
            response = this.jsonRestHandler.cancelTask(taskId, context);
            return response;
        }
        catch (Throwable t) {
            response = this.jsonRestHandler.createErrorResponse((JSONRPCError)new InternalError(t.getMessage()));
            return response;
        }
        finally {
            return Response.status((int)response.getStatusCode()).header("Content-Type", (Object)response.getContentType()).entity((Object)response.getBody()).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="v1/tasks/{taskId}/pushNotificationConfigs")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setTaskPushNotificationConfiguration(@PathParam(value="taskId") String taskId, String body, @Context HttpServletRequest httpRequest, @Context SecurityContext securityContext) {
        ServerCallContext context = this.createCallContext(httpRequest, securityContext);
        RestHandler.HTTPRestResponse response = null;
        try {
            response = this.jsonRestHandler.setTaskPushNotificationConfiguration(taskId, body, context);
            return response;
        }
        catch (Throwable t) {
            response = this.jsonRestHandler.createErrorResponse((JSONRPCError)new InternalError(t.getMessage()));
            return response;
        }
        finally {
            return Response.status((int)response.getStatusCode()).header("Content-Type", (Object)response.getContentType()).entity((Object)response.getBody()).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="v1/tasks/{taskId}/pushNotificationConfigs/{configId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getTaskPushNotificationConfiguration(@PathParam(value="taskId") String taskId, @PathParam(value="configId") String configId, @Context HttpServletRequest httpRequest, @Context SecurityContext securityContext) {
        ServerCallContext context = this.createCallContext(httpRequest, securityContext);
        RestHandler.HTTPRestResponse response = null;
        try {
            response = this.jsonRestHandler.getTaskPushNotificationConfiguration(taskId, configId, context);
            return response;
        }
        catch (Throwable t) {
            response = this.jsonRestHandler.createErrorResponse((JSONRPCError)new InternalError(t.getMessage()));
            return response;
        }
        finally {
            return Response.status((int)response.getStatusCode()).header("Content-Type", (Object)response.getContentType()).entity((Object)response.getBody()).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="v1/tasks/{taskId}/pushNotificationConfigs")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response listTaskPushNotificationConfigurations(@PathParam(value="taskId") String taskId, @Context HttpServletRequest httpRequest, @Context SecurityContext securityContext) {
        ServerCallContext context = this.createCallContext(httpRequest, securityContext);
        RestHandler.HTTPRestResponse response = null;
        try {
            response = this.jsonRestHandler.listTaskPushNotificationConfigurations(taskId, context);
            return response;
        }
        catch (Throwable t) {
            response = this.jsonRestHandler.createErrorResponse((JSONRPCError)new InternalError(t.getMessage()));
            return response;
        }
        finally {
            return Response.status((int)response.getStatusCode()).header("Content-Type", (Object)response.getContentType()).entity((Object)response.getBody()).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="v1/tasks/{taskId}/pushNotificationConfigs/{configId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteTaskPushNotificationConfiguration(@PathParam(value="taskId") String taskId, @PathParam(value="configId") String configId, @Context HttpServletRequest httpRequest, @Context SecurityContext securityContext) {
        ServerCallContext context = this.createCallContext(httpRequest, securityContext);
        RestHandler.HTTPRestResponse response = null;
        try {
            response = this.jsonRestHandler.deleteTaskPushNotificationConfiguration(taskId, configId, context);
            return response;
        }
        catch (Throwable t) {
            response = this.jsonRestHandler.createErrorResponse((JSONRPCError)new InternalError(t.getMessage()));
            return response;
        }
        finally {
            return Response.status((int)response.getStatusCode()).header("Content-Type", (Object)response.getContentType()).entity((Object)response.getBody()).build();
        }
    }

    private void handleCustomSSEResponse(Flow.Publisher<String> publisher, HttpServletResponse response) throws IOException {
        CompletableFuture<Void> streamingComplete = new CompletableFuture<Void>();
        try (PrintWriter writer = response.getWriter();){
            publisher.subscribe(new SSESubscriber(streamingComplete, writer));
            streamingComplete.get();
        }
        catch (Exception e) {
            LOGGER.error("Error waiting for streaming completion: {}", (Object)e.getMessage(), (Object)e);
            throw new IOException("Streaming failed", e);
        }
    }

    public static void setStreamingIsSubscribedRunnable(Runnable streamingIsSubscribedRunnable) {
        A2ARestServerResource.streamingIsSubscribedRunnable = streamingIsSubscribedRunnable;
        SSESubscriber.setStreamingIsSubscribedRunnable(streamingIsSubscribedRunnable);
    }

    private ServerCallContext createCallContext(HttpServletRequest request, final SecurityContext securityContext) {
        if (this.callContextFactory.isUnsatisfied()) {
            Object user = securityContext.getUserPrincipal() == null ? UnauthenticatedUser.INSTANCE : new User(){

                public boolean isAuthenticated() {
                    return true;
                }

                public String getUsername() {
                    return securityContext.getUserPrincipal().getName();
                }
            };
            HashMap state = new HashMap();
            HashMap<String, String> headers = new HashMap<String, String>();
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                headers.put(name, request.getHeader(name));
            }
            state.put("headers", headers);
            return new ServerCallContext((User)user, state);
        }
        CallContextFactory builder = (CallContextFactory)this.callContextFactory.get();
        return builder.build(request);
    }
}

