/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.util.ArrayList;
import java.util.Scanner;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.deployment.Validate;
import org.jboss.as.arquillian.container.CommonContainerConfiguration;

public class CommonManagedContainerConfiguration
extends CommonContainerConfiguration {
    private static final Integer DEFAULT_VALUE_WAIT_FOR_PORTS_TIMEOUT_SECONDS = 10;
    private String javaHome = System.getenv("JAVA_HOME");
    private int startupTimeoutInSeconds = 60;
    private int stopTimeoutInSeconds = 60;
    private boolean outputToConsole = true;
    private boolean allowConnectingToRunningServer = Boolean.parseBoolean(System.getProperty("allowConnectingToRunningServer", "false"));
    private Integer[] waitForPorts;
    private Integer waitForPortsTimeoutInSeconds;

    @Override
    public void validate() throws ConfigurationException {
        super.validate();
        if (this.javaHome != null) {
            Validate.configurationDirectoryExists((String)this.javaHome, (String)("javaHome '" + this.javaHome + "' must exist"));
        }
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    public void setStartupTimeoutInSeconds(int startupTimeoutInSeconds) {
        this.startupTimeoutInSeconds = startupTimeoutInSeconds;
    }

    public int getStartupTimeoutInSeconds() {
        return this.startupTimeoutInSeconds;
    }

    public void setStopTimeoutInSeconds(int stopTimeoutInSeconds) {
        this.stopTimeoutInSeconds = stopTimeoutInSeconds;
    }

    public int getStopTimeoutInSeconds() {
        return this.stopTimeoutInSeconds;
    }

    public void setOutputToConsole(boolean outputToConsole) {
        this.outputToConsole = outputToConsole;
    }

    public boolean isOutputToConsole() {
        return this.outputToConsole;
    }

    public boolean isAllowConnectingToRunningServer() {
        return this.allowConnectingToRunningServer;
    }

    public void setAllowConnectingToRunningServer(boolean allowConnectingToRunningServer) {
        this.allowConnectingToRunningServer = allowConnectingToRunningServer;
    }

    public Integer[] getWaitForPorts() {
        return this.waitForPorts;
    }

    public void setWaitForPorts(String waitForPorts) {
        Scanner scanner = new Scanner(waitForPorts);
        ArrayList<Integer> list = new ArrayList<Integer>();
        while (scanner.hasNextInt()) {
            list.add(scanner.nextInt());
        }
        this.waitForPorts = list.toArray(new Integer[0]);
    }

    public Integer getWaitForPortsTimeoutInSeconds() {
        return this.waitForPortsTimeoutInSeconds != null ? this.waitForPortsTimeoutInSeconds : DEFAULT_VALUE_WAIT_FOR_PORTS_TIMEOUT_SECONDS;
    }

    public void setWaitForPortsTimeoutInSeconds(Integer waitForPortsTimeoutInSeconds) {
        this.waitForPortsTimeoutInSeconds = waitForPortsTimeoutInSeconds;
    }
}

