/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.controller;

import java.util.List;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.client.deployment.Deployment;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentScenario;
import org.jboss.arquillian.container.spi.client.deployment.TargetDescription;
import org.jboss.arquillian.container.spi.event.UnDeployDeployment;
import org.jboss.arquillian.container.test.impl.client.container.ClientContainerController;
import org.jboss.as.arquillian.api.WildFlyContainerController;
import org.jboss.as.arquillian.container.controller.StopContainerWithTimeout;

public class ClientWildFlyContainerController
extends ClientContainerController
implements WildFlyContainerController {
    private final Logger log = Logger.getLogger(ClientWildFlyContainerController.class.getName());

    @Override
    public void stop(String containerQualifier, int timeout) {
        DeploymentScenario scenario = (DeploymentScenario)this.getDeploymentScenario().get();
        if (scenario == null) {
            throw new IllegalArgumentException("No deployment scenario in context");
        }
        ContainerRegistry registry = (ContainerRegistry)this.getContainerRegistry().get();
        if (registry == null) {
            throw new IllegalArgumentException("No container registry in context");
        }
        if (!this.containerExists(registry.getContainers(), containerQualifier)) {
            throw new IllegalArgumentException("No container with the specified name exists");
        }
        if (!this.isControllableContainer(registry.getContainers(), containerQualifier)) {
            throw new IllegalArgumentException("Could not start " + containerQualifier + " container. The container life cycle is controlled by Arquillian");
        }
        Container container = ((ContainerRegistry)this.getContainerRegistry().get()).getContainer(new TargetDescription(containerQualifier));
        List managedDeployments = scenario.startupDeploymentsFor(new TargetDescription(containerQualifier));
        for (Deployment d : managedDeployments) {
            if (!d.isDeployed()) continue;
            this.log.info("Automatic undeploying of the managed deployment with name " + d.getDescription().getName() + " from the container with name " + container.getName());
            this.getContainerControllerEvent().fire((Object)new UnDeployDeployment(container, d));
        }
        this.log.info("Manual stopping of a server instance with timeout=" + timeout);
        this.getContainerControllerEvent().fire((Object)new StopContainerWithTimeout(container, timeout));
    }
}

