/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.arquillian.junit.condition;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wildfly.arquillian.junit.annotations.RequiresModule;
import org.wildfly.arquillian.junit.condition.SecurityActions;
import org.wildfly.plugin.tools.VersionComparator;
import org.xml.sax.SAXException;

public class RequiresModuleExecutionCondition
implements ExecutionCondition {
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        return AnnotationSupport.findAnnotation((Optional)context.getElement(), RequiresModule.class).map(this::checkModule).orElse(ConditionEvaluationResult.enabled((String)"Could not determine the @RequiresModule was found, enabling by default"));
    }

    private ConditionEvaluationResult checkModule(RequiresModule requiresModule) {
        Path moduleDir = RequiresModuleExecutionCondition.resolveModulesDir();
        if (moduleDir == null) {
            return ConditionEvaluationResult.enabled((String)"The module directory could not be resolved.");
        }
        try {
            Optional<Path> moduleXmlFile = RequiresModuleExecutionCondition.findModuleXml(moduleDir, RequiresModuleExecutionCondition.moduleToPath(requiresModule.value()));
            if (moduleXmlFile.isPresent()) {
                if (requiresModule.minVersion().isBlank()) {
                    return ConditionEvaluationResult.enabled((String)RequiresModuleExecutionCondition.formatReason(requiresModule, "Module %s found in %s. Enabling test.", requiresModule.value(), moduleXmlFile.get()));
                }
                return this.checkVersion(requiresModule, moduleXmlFile.get());
            }
        }
        catch (IOException e) {
            return ConditionEvaluationResult.enabled((String)("Could not find module " + requiresModule.value() + ". Enabling by default. Reason: " + e.getMessage()));
        }
        return ConditionEvaluationResult.disabled((String)RequiresModuleExecutionCondition.formatReason(requiresModule, "Module %s not found in %s. Disabling test.", requiresModule.value(), moduleDir));
    }

    private ConditionEvaluationResult checkVersion(RequiresModule requiresModule, Path moduleXmlFile) {
        try {
            String version = RequiresModuleExecutionCondition.version(moduleXmlFile);
            if (version.isBlank()) {
                return ConditionEvaluationResult.enabled((String)String.format("Could not determine version of module %s", moduleXmlFile));
            }
            if (RequiresModuleExecutionCondition.isAtLeastVersion(requiresModule.minVersion(), version)) {
                return ConditionEvaluationResult.enabled((String)String.format("Found version %s and required a minimum of version %s. Enabling tests.", version, requiresModule.minVersion()));
            }
            return ConditionEvaluationResult.disabled((String)RequiresModuleExecutionCondition.formatReason(requiresModule, "Found version %s and required a minimum of version %s. Disabling test.", version, requiresModule.minVersion()));
        }
        catch (IOException e) {
            return ConditionEvaluationResult.enabled((String)String.format("Could not determine the version for module %s. Enabling by default. Reason: %s", requiresModule.value(), e.getMessage()));
        }
    }

    private static String moduleToPath(String moduleName) {
        return String.join((CharSequence)File.separator, moduleName.split("\\."));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String version(Path moduleXmlFile) throws IOException {
        try (InputStream in = Files.newInputStream(moduleXmlFile, new OpenOption[0]);){
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(in);
            NodeList resources = document.getElementsByTagName("resources");
            if (resources.getLength() <= 0) return "";
            Node resource = resources.item(0);
            NodeList nodes = resource.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if (node.getNodeName().equals("artifact")) {
                    String name = node.getAttributes().getNamedItem("name").getTextContent();
                    String[] gav = name.split(":");
                    if (gav.length <= 2) return "";
                    String string = RequiresModuleExecutionCondition.sanitizeVersion(gav[2]);
                    return string;
                }
                if (node.getNodeName().equals("resource-root")) {
                    String path = node.getAttributes().getNamedItem("path").getTextContent();
                    Path parent = moduleXmlFile.getParent();
                    Path jar = parent == null ? Path.of(path, new String[0]) : parent.resolve(path);
                    try (JarFile jarFile = new JarFile(jar.toFile());){
                        String string = RequiresModuleExecutionCondition.extractVersionFromManifest(jarFile);
                        return string;
                    }
                }
                ++i;
            }
            return "";
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException("Failed to parse module XML file " + moduleXmlFile, e);
        }
    }

    private static String extractVersionFromManifest(JarFile jarFile) throws IOException {
        Manifest manifest = jarFile.getManifest();
        String version = manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        return RequiresModuleExecutionCondition.sanitizeVersion(version);
    }

    private static String sanitizeVersion(String version) {
        if (version == null) {
            return "";
        }
        int end = version.indexOf("-redhat");
        if (end > 0) {
            return version.substring(0, end);
        }
        return version;
    }

    private static Optional<Path> findModuleXml(Path dir, String pathName) throws IOException {
        try (Stream<Path> files = Files.walk(dir, new FileVisitOption[0]);){
            Optional<Path> optional = files.filter(f -> f.toString().contains(pathName) && f.getFileName().toString().equals("module.xml")).findFirst();
            return optional;
        }
    }

    private static boolean isAtLeastVersion(String minVersion, String foundVersion) {
        if (foundVersion == null) {
            return false;
        }
        return VersionComparator.compareVersion((String)foundVersion, (String)minVersion) >= 0;
    }

    private static String formatReason(RequiresModule requiresModule, String fmt, Object ... args) {
        Object msg = String.format(fmt, args);
        if (!requiresModule.issueRef().isBlank()) {
            msg = requiresModule.issueRef() + ": " + (String)msg;
        }
        if (!requiresModule.reason().isBlank()) {
            msg = (String)msg + " Reason: " + requiresModule.reason();
        }
        return msg;
    }

    private static Path resolveModulesDir() {
        String moduleDir = SecurityActions.getSystemProperty("module.path");
        if (moduleDir != null) {
            return Path.of(moduleDir, new String[0]);
        }
        String jbossHome = SecurityActions.resolveJBossHome();
        if (jbossHome == null) {
            return null;
        }
        return Path.of(jbossHome, "modules");
    }
}

