/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.arquillian.junit.condition;

import java.io.File;
import java.nio.file.Path;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.wildfly.arquillian.junit.annotations.JBossHome;
import org.wildfly.arquillian.junit.condition.SecurityActions;

public class JBossHomeParameterResolver
implements ParameterResolver {
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (!parameterContext.isAnnotated(JBossHome.class)) {
            return false;
        }
        Class<Object> parameterType = parameterContext.getParameter().getType();
        return parameterType.isAssignableFrom(Path.class) || parameterType.isAssignableFrom(String.class) || parameterType.isAssignableFrom(File.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        String value = SecurityActions.resolveJBossHome();
        if (value == null) {
            throw new ParameterResolutionException("Could not resolve the jboss.home system property or JBOSS_HOME environment variable.");
        }
        Path path = Path.of(value, new String[0]).toAbsolutePath();
        Class<Object> parameterType = parameterContext.getParameter().getType();
        if (parameterType.isAssignableFrom(Path.class)) {
            return path;
        }
        if (parameterType.isAssignableFrom(String.class)) {
            return path.toString();
        }
        if (parameterType.isAssignableFrom(File.class)) {
            return path.toFile();
        }
        throw new ParameterResolutionException("Cannot convert the JBoss Home directory into a type of " + parameterType.getName());
    }
}

