/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.arquillian.junit.condition;

import java.security.AccessController;

class SecurityActions {
    SecurityActions() {
    }

    static String getSystemProperty(String name) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(name);
        }
        return AccessController.doPrivileged(() -> System.getProperty(name));
    }

    static String resolveJBossHome() {
        if (System.getSecurityManager() == null) {
            String value = System.getProperty("jboss.home");
            if (value == null) {
                value = System.getenv("JBOSS_HOME");
            }
            if (value == null) {
                value = System.getProperty("jboss.home.dir");
            }
            return value;
        }
        return AccessController.doPrivileged(() -> {
            String value = System.getProperty("jboss.home");
            if (value == null) {
                value = System.getenv("JBOSS_HOME");
            }
            if (value == null) {
                value = System.getProperty("jboss.home.dir");
            }
            return value;
        });
    }
}

