/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.testing.tools.modules;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ModuleDependency
implements Comparable<ModuleDependency> {
    private final String name;
    private final boolean export;
    private final boolean optional;
    private final Services services;
    private final Set<Filter> imports;
    private final Set<Filter> exports;

    private ModuleDependency(String name, boolean export, boolean optional, Services services, Set<Filter> imports, Set<Filter> exports) {
        this.name = name;
        this.export = export;
        this.optional = optional;
        this.services = services;
        this.imports = imports;
        this.exports = exports;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public String name() {
        return this.name;
    }

    public boolean isExport() {
        return this.export;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public Set<Filter> imports() {
        return this.imports;
    }

    public Set<Filter> exports() {
        return this.exports;
    }

    public Optional<Services> services() {
        return Optional.ofNullable(this.services);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ModuleDependency)) {
            return false;
        }
        ModuleDependency other = (ModuleDependency)obj;
        return Objects.equals(this.name, other.name);
    }

    public String toString() {
        return "ModuleDependency[name=" + this.name + ", export=" + this.export + ", optional=" + this.optional + ", services=" + String.valueOf((Object)this.services) + ", imports=" + String.valueOf(this.imports) + ", exports=" + String.valueOf(this.exports) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Override
    public int compareTo(ModuleDependency o) {
        return this.name.compareTo(o.name);
    }

    public static enum Services {
        NONE,
        IMPORT,
        EXPORT;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static class Builder {
        private final String name;
        private boolean optional;
        private boolean export;
        private Services services;
        private final Set<Filter> imports;
        private final Set<Filter> exports;

        private Builder(String name) {
            this.name = name;
            this.imports = new LinkedHashSet<Filter>();
            this.exports = new LinkedHashSet<Filter>();
        }

        public Builder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public Builder export(boolean export) {
            this.export = export;
            return this;
        }

        public Builder services(Services services) {
            this.services = services;
            return this;
        }

        public Builder addImportFilter(Filter filter) {
            this.imports.add(filter);
            return this;
        }

        public Builder addImportFilter(String path, boolean include) {
            return this.addImportFilter(Filter.of(path, include));
        }

        public Builder addImportFilters(Filter ... filters) {
            this.imports.addAll(Set.of(filters));
            return this;
        }

        public Builder addImportFilters(Collection<Filter> filters) {
            this.imports.addAll(filters);
            return this;
        }

        public Builder addExportFilter(Filter filter) {
            this.exports.add(filter);
            return this;
        }

        public Builder addExportFilter(String path, boolean include) {
            return this.addExportFilter(Filter.of(path, include));
        }

        public Builder addExportFilters(Filter ... filters) {
            return this.addExportFilters(Set.of(filters));
        }

        public Builder addExportFilters(Collection<Filter> filters) {
            this.exports.addAll(filters);
            return this;
        }

        public ModuleDependency build() {
            return new ModuleDependency(this.name, this.export, this.optional, this.services, Set.copyOf(this.imports), Set.copyOf(this.exports));
        }
    }

    private static class PathFilter
    implements Filter {
        private final String path;
        private final boolean include;

        private PathFilter(String path, boolean include) {
            this.path = path;
            this.include = include;
        }

        @Override
        public String path() {
            return this.path;
        }

        @Override
        public boolean include() {
            return this.include;
        }

        public int hashCode() {
            return Objects.hash(this.path, this.include);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PathFilter)) {
                return false;
            }
            PathFilter other = (PathFilter)obj;
            return Objects.equals(this.path, other.path) && Objects.equals(this.include, other.include);
        }

        public String toString() {
            return "Filter[path=" + this.path + ", include=" + this.include + "]";
        }

        @Override
        public int compareTo(Filter o) {
            int result = this.path().compareTo(o.path());
            if (result == 0) {
                result = Boolean.compare(this.include, o.include());
            }
            return result;
        }
    }

    public static interface Filter
    extends Comparable<Filter> {
        public static Filter of(String path, boolean include) {
            return new PathFilter(path, include);
        }

        public String path();

        public boolean include();
    }
}

