/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.testing.tools.modules;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import org.jboss.logging.Logger;
import org.wildfly.testing.tools.modules.ModuleBuilder;
import org.wildfly.testing.tools.modules.Modules;
import org.wildfly.testing.tools.xml.CloseableXMLStreamWriter;

public final class ModuleDescription
implements AutoCloseable,
Comparable<ModuleDescription> {
    private final String name;
    private final Path baseModulePath;
    private final Path modulePath;

    ModuleDescription(String name, Path baseModulePath, Path modulePath) {
        this.name = Objects.requireNonNull(name);
        this.baseModulePath = Objects.requireNonNull(baseModulePath);
        this.modulePath = Objects.requireNonNull(modulePath);
    }

    public static ModuleDescription createAlias(String moduleName, String targetName) {
        return ModuleDescription.createAlias(Modules.discoverModulePath(), moduleName, targetName);
    }

    public static ModuleDescription createAlias(Path modulePath, String moduleName, String targetName) {
        Path mp = modulePath == null ? Modules.discoverModulePath() : modulePath;
        Path moduleDir = mp.resolve(moduleName.replace('.', File.separatorChar)).resolve("main");
        try {
            if (Files.notExists(moduleDir, new LinkOption[0])) {
                Files.createDirectories(moduleDir, new FileAttribute[0]);
            }
            try (CloseableXMLStreamWriter writer = CloseableXMLStreamWriter.of(Files.newBufferedWriter(moduleDir.resolve("module.xml"), new OpenOption[0]));){
                writer.writeStartDocument("utf-8", "1.0");
                writer.writeEmptyElement("module-alias");
                writer.writeNamespace(null, "urn:jboss:module:1.9");
                writer.writeAttribute("name", moduleName);
                writer.writeAttribute("target-name", targetName);
                writer.writeEndDocument();
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(String.format("Failed to create the module-alias for %s with a target of %s", moduleName, targetName), e);
            }
            return new ModuleDescription(moduleName, mp, moduleDir);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to create the module-alias for %s with a target of %s", moduleName, targetName), e);
        }
    }

    public String name() {
        return this.name;
    }

    public Path modulePath() {
        return this.modulePath;
    }

    @Override
    public int compareTo(ModuleDescription o) {
        int result = this.name.compareTo(o.name);
        if (result == 0) {
            result = this.modulePath.compareTo(o.modulePath);
        }
        return result;
    }

    @Override
    public void close() {
        try {
            this.delete(this.modulePath, true);
        }
        catch (IOException ignore) {
            Thread task = new Thread(() -> {
                try {
                    this.delete(this.modulePath, true);
                }
                catch (IOException e) {
                    Logger.getLogger(ModuleBuilder.class).errorf((Throwable)e, "Failed to delete module %s", (Object)this.name);
                }
            }, String.format("%s-shutdown", this.name));
            task.setDaemon(true);
            Runtime.getRuntime().addShutdownHook(task);
        }
    }

    public String toString() {
        return "ModuleDescription{name='" + this.name + "', modulePath=" + String.valueOf(this.modulePath) + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ModuleDescription)) {
            return false;
        }
        ModuleDescription other = (ModuleDescription)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.modulePath, other.modulePath);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.modulePath);
    }

    private void delete(Path dir, boolean deleteFiles) throws IOException {
        if (deleteFiles) {
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(dir);){
                for (Path path : dirStream) {
                    if (Files.isDirectory(path, new LinkOption[0])) continue;
                    Files.delete(path);
                }
            }
        }
        if (!this.isDirectoryEmpty(dir)) {
            return;
        }
        Files.delete(dir);
        Path parent = dir.getParent();
        if (parent != null && !parent.equals(this.baseModulePath)) {
            this.delete(parent, false);
        }
    }

    private boolean isDirectoryEmpty(Path dir) throws IOException {
        try (Stream<Path> files = Files.list(dir);){
            boolean bl = files.findAny().isEmpty();
            return bl;
        }
    }
}

