/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class FileUtils {
    public static void extractFile(JarFile jarFile, String jarEntryName, File targetFile) throws IOException {
        byte[] data = new byte[1024];
        ZipEntry entry = jarFile.getEntry(jarEntryName);
        if (entry.isDirectory()) {
            targetFile.mkdir();
            return;
        }
        try (FileOutputStream fos = new FileOutputStream(targetFile);
             InputStream is = jarFile.getInputStream(entry);){
            int read;
            while ((read = is.read(data)) > 0) {
                fos.write(data, 0, read);
            }
        }
    }

    public static void copyFile(InputStream in, File dest) throws IOException {
        dest.getParentFile().mkdirs();
        byte[] data = new byte[10000];
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));){
            int read;
            while ((read = in.read(data)) > 0) {
                ((OutputStream)out).write(data, 0, read);
            }
        }
    }

    public static void copyFile(File src, File dest) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(src));){
            FileUtils.copyFile(in, dest);
        }
    }

    public static String readFile(File file) {
        try {
            return FileUtils.readFile(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFile(InputStream file) {
        try (BufferedInputStream stream = new BufferedInputStream(file);){
            byte[] buff = new byte[1024];
            StringBuilder builder = new StringBuilder();
            int read = -1;
            while ((read = stream.read(buff)) != -1) {
                builder.append(new String(buff, 0, read));
            }
            String string = builder.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void deleteRecursive(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                FileUtils.deleteRecursive(f);
            }
        }
        file.delete();
    }
}

