/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.pack.model;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.wildfly.build.pack.model.Artifact;
import org.wildfly.build.pack.model.Config;
import org.wildfly.build.pack.model.ConfigFile;
import org.wildfly.build.pack.model.CopyArtifact;
import org.wildfly.build.pack.model.FeaturePackDescription;
import org.wildfly.build.pack.model.FeaturePackDescriptionXMLParser10;
import org.wildfly.build.pack.model.FileFilter;
import org.wildfly.build.pack.model.FilePermission;
import org.wildfly.build.util.xml.AttributeValue;
import org.wildfly.build.util.xml.ElementNode;
import org.wildfly.build.util.xml.FormattingXMLStreamWriter;

public class FeaturePackDescriptionXMLWriter10 {
    public static final FeaturePackDescriptionXMLWriter10 INSTANCE = new FeaturePackDescriptionXMLWriter10();

    private FeaturePackDescriptionXMLWriter10() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(FeaturePackDescription featurePackDescription, File outputFile) throws XMLStreamException, IOException {
        ElementNode featurePackElementNode = new ElementNode(null, FeaturePackDescriptionXMLParser10.Element.FEATURE_PACK.getLocalName(), "urn:wildfly:feature-pack:1.0");
        this.processDependencies(featurePackDescription.getDependencies(), featurePackElementNode);
        this.processArtifactVersions(featurePackDescription.getArtifactVersions(), featurePackElementNode);
        this.processConfig(featurePackDescription.getConfig(), featurePackElementNode);
        this.processCopyArtifacts(featurePackDescription.getCopyArtifacts(), featurePackElementNode);
        this.processFilePermissions(featurePackDescription.getFilePermissions(), featurePackElementNode);
        FormattingXMLStreamWriter writer = new FormattingXMLStreamWriter(XMLOutputFactory.newInstance().createXMLStreamWriter(new BufferedWriter(new FileWriter(outputFile))));
        try {
            writer.writeStartDocument();
            featurePackElementNode.marshall(writer);
            writer.writeEndDocument();
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception ignore) {}
        }
    }

    protected void processDependencies(List<String> dependencies, ElementNode featurePackElementNode) {
        if (!dependencies.isEmpty()) {
            ElementNode dependenciesElementNode = new ElementNode(featurePackElementNode, FeaturePackDescriptionXMLParser10.Element.DEPENDENCIES.getLocalName());
            for (String artifactName : dependencies) {
                ElementNode artifactElementNode = new ElementNode(dependenciesElementNode, FeaturePackDescriptionXMLParser10.Element.ARTIFACT.getLocalName());
                artifactElementNode.addAttribute(FeaturePackDescriptionXMLParser10.Attribute.NAME.getLocalName(), new AttributeValue(artifactName));
                dependenciesElementNode.addChild(artifactElementNode);
            }
            featurePackElementNode.addChild(dependenciesElementNode);
        }
    }

    protected void processArtifactVersions(Set<Artifact> artifactVersions, ElementNode featurePackElementNode) {
        if (!artifactVersions.isEmpty()) {
            ElementNode versionsElementNode = new ElementNode(featurePackElementNode, FeaturePackDescriptionXMLParser10.Element.ARTIFACT_VERSIONS.getLocalName());
            for (Artifact artifact : artifactVersions) {
                this.processArtifact(artifact, versionsElementNode);
            }
            featurePackElementNode.addChild(versionsElementNode);
        }
    }

    protected void processArtifact(Artifact artifact, ElementNode versionsElementNode) {
        ElementNode artifactElementNode = new ElementNode(versionsElementNode, FeaturePackDescriptionXMLParser10.Element.ARTIFACT.getLocalName());
        Artifact.GACE GACE2 = artifact.getGACE();
        artifactElementNode.addAttribute(FeaturePackDescriptionXMLParser10.Attribute.GROUP_ID.getLocalName(), new AttributeValue(GACE2.getGroupId()));
        artifactElementNode.addAttribute(FeaturePackDescriptionXMLParser10.Attribute.ARTIFACT_ID.getLocalName(), new AttributeValue(GACE2.getArtifactId()));
        artifactElementNode.addAttribute(FeaturePackDescriptionXMLParser10.Attribute.VERSION.getLocalName(), new AttributeValue(artifact.getVersion()));
        if (GACE2.getClassifier() != null) {
            artifactElementNode.addAttribute(FeaturePackDescriptionXMLParser10.Attribute.CLASSIFIER.getLocalName(), new AttributeValue(GACE2.getClassifier()));
        }
        if (GACE2.getExtension() != null) {
            artifactElementNode.addAttribute(FeaturePackDescriptionXMLParser10.Attribute.EXTENSION.getLocalName(), new AttributeValue(GACE2.getExtension()));
        }
        versionsElementNode.addChild(artifactElementNode);
    }

    protected void processConfig(Config config, ElementNode featurePackElementNode) {
        if (!config.getStandaloneConfigFiles().isEmpty() || !config.getDomainConfigFiles().isEmpty()) {
            ElementNode configElementNode = new ElementNode(featurePackElementNode, FeaturePackDescriptionXMLParser10.Element.CONFIG.getLocalName());
            for (ConfigFile configFile : config.getStandaloneConfigFiles()) {
                ElementNode standaloneElementNode = new ElementNode(featurePackElementNode, FeaturePackDescriptionXMLParser10.Element.STANDALONE.getLocalName());
                this.processConfigFile(configFile, standaloneElementNode);
                configElementNode.addChild(standaloneElementNode);
            }
            for (ConfigFile configFile : config.getDomainConfigFiles()) {
                ElementNode domainElementNode = new ElementNode(featurePackElementNode, FeaturePackDescriptionXMLParser10.Element.DOMAIN.getLocalName());
                this.processConfigFile(configFile, domainElementNode);
                configElementNode.addChild(domainElementNode);
            }
            featurePackElementNode.addChild(configElementNode);
        }
    }

    protected void processConfigFile(ConfigFile configFile, ElementNode configElementNode) {
        for (Map.Entry<String, String> property : configFile.getProperties().entrySet()) {
            ElementNode propertyElementNode = new ElementNode(configElementNode, FeaturePackDescriptionXMLParser10.Element.PROPERTY.getLocalName());
            propertyElementNode.addAttribute(FeaturePackDescriptionXMLParser10.Attribute.NAME.getLocalName(), new AttributeValue(property.getKey()));
            propertyElementNode.addAttribute(FeaturePackDescriptionXMLParser10.Attribute.VALUE.getLocalName(), new AttributeValue(property.getValue()));
            configElementNode.addChild(propertyElementNode);
        }
        configElementNode.addAttribute(FeaturePackDescriptionXMLParser10.Attribute.TEMPLATE.getLocalName(), new AttributeValue(configFile.getTemplate()));
        configElementNode.addAttribute(FeaturePackDescriptionXMLParser10.Attribute.SUBSYSTEMS.getLocalName(), new AttributeValue(configFile.getSubsystems()));
        configElementNode.addAttribute(FeaturePackDescriptionXMLParser10.Attribute.OUTPUT_FILE.getLocalName(), new AttributeValue(configFile.getOutputFile()));
    }

    protected void processCopyArtifacts(List<CopyArtifact> copyArtifacts, ElementNode featurePackElementNode) {
        if (!copyArtifacts.isEmpty()) {
            ElementNode artifactsElementNode = new ElementNode(featurePackElementNode, FeaturePackDescriptionXMLParser10.Element.COPY_ARTIFACTS.getLocalName());
            for (CopyArtifact copyArtifact : copyArtifacts) {
                ElementNode copyArtifactElementNode = new ElementNode(featurePackElementNode, FeaturePackDescriptionXMLParser10.Element.COPY_ARTIFACT.getLocalName());
                this.processCopyArtifact(copyArtifact, copyArtifactElementNode);
                artifactsElementNode.addChild(copyArtifactElementNode);
            }
            featurePackElementNode.addChild(artifactsElementNode);
        }
    }

    protected void processCopyArtifact(CopyArtifact copyArtifact, ElementNode copyArtifactElementNode) {
        this.processFilters(copyArtifact.getFilters(), copyArtifactElementNode);
        copyArtifactElementNode.addAttribute(FeaturePackDescriptionXMLParser10.Attribute.ARTIFACT.getLocalName(), new AttributeValue(copyArtifact.getArtifact()));
        copyArtifactElementNode.addAttribute(FeaturePackDescriptionXMLParser10.Attribute.TO_LOCATION.getLocalName(), new AttributeValue(copyArtifact.getToLocation()));
        if (copyArtifact.isExtract()) {
            copyArtifactElementNode.addAttribute(FeaturePackDescriptionXMLParser10.Attribute.EXTRACT.getLocalName(), new AttributeValue(Boolean.toString(copyArtifact.isExtract())));
        }
    }

    protected void processFilters(List<FileFilter> fileFilters, ElementNode elementNode) {
        if (!fileFilters.isEmpty()) {
            for (FileFilter fileFilter : fileFilters) {
                this.processFileFilter(fileFilter, elementNode);
            }
        }
    }

    protected void processFileFilter(FileFilter fileFilter, ElementNode elementNode) {
        ElementNode fileFilterElementNode = new ElementNode(elementNode, FeaturePackDescriptionXMLParser10.Element.FILTER.getLocalName());
        fileFilterElementNode.addAttribute(FeaturePackDescriptionXMLParser10.Attribute.PATTERN.getLocalName(), new AttributeValue(fileFilter.getPattern().pattern()));
        fileFilterElementNode.addAttribute(FeaturePackDescriptionXMLParser10.Attribute.INCLUDE.getLocalName(), new AttributeValue(Boolean.toString(fileFilter.isInclude())));
        elementNode.addChild(fileFilterElementNode);
    }

    protected void processFilePermissions(List<FilePermission> filePermissions, ElementNode wildflyPackElementNode) {
        if (!filePermissions.isEmpty()) {
            ElementNode filePermissionsElementNode = new ElementNode(wildflyPackElementNode, FeaturePackDescriptionXMLParser10.Element.FILE_PERMISSIONS.getLocalName());
            for (FilePermission filePermission : filePermissions) {
                this.processFilePermission(filePermission, filePermissionsElementNode);
            }
            wildflyPackElementNode.addChild(filePermissionsElementNode);
        }
    }

    protected void processFilePermission(FilePermission filePermission, ElementNode filePermissionsElementNode) {
        ElementNode filePermissionElementNode = new ElementNode(filePermissionsElementNode, FeaturePackDescriptionXMLParser10.Element.PERMISSION.getLocalName());
        this.processFilters(filePermission.getFilters(), filePermissionElementNode);
        filePermissionElementNode.addAttribute(FeaturePackDescriptionXMLParser10.Attribute.VALUE.getLocalName(), new AttributeValue(filePermission.getValue()));
        filePermissionsElementNode.addChild(filePermissionElementNode);
    }
}

