/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.pack.model;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.build.pack.model.Artifact;
import org.wildfly.build.pack.model.Config;
import org.wildfly.build.pack.model.ConfigFile;
import org.wildfly.build.pack.model.CopyArtifact;
import org.wildfly.build.pack.model.FeaturePackDescription;
import org.wildfly.build.pack.model.FileFilter;
import org.wildfly.build.pack.model.FilePermission;
import org.wildfly.build.util.BuildPropertyReplacer;
import org.wildfly.build.util.PropertyResolver;
import org.wildfly.build.util.xml.ParsingUtils;

class FeaturePackDescriptionXMLParser10
implements XMLElementReader<FeaturePackDescription> {
    private final BuildPropertyReplacer propertyReplacer;
    public static final String NAMESPACE_1_0 = "urn:wildfly:feature-pack:1.0";

    FeaturePackDescriptionXMLParser10(PropertyResolver resolver) {
        this.propertyReplacer = new BuildPropertyReplacer(resolver);
    }

    public void readElement(XMLExtendedStreamReader reader, FeaturePackDescription result) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.noneOf(Attribute.class);
        int i = 0;
        int count = reader.getAttributeCount();
        if (i < count) {
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), required);
        }
        block11: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case DEPENDENCIES: {
                            this.parseDependencies((XMLStreamReader)reader, result);
                            continue block11;
                        }
                        case ARTIFACT_VERSIONS: {
                            this.parseArtifactVersions((XMLStreamReader)reader, result);
                            continue block11;
                        }
                        case CONFIG: {
                            this.parseConfig((XMLStreamReader)reader, result.getConfig());
                            continue block11;
                        }
                        case COPY_ARTIFACTS: {
                            this.parseCopyArtifacts((XMLStreamReader)reader, result);
                            continue block11;
                        }
                        case FILE_PERMISSIONS: {
                            this.parseFilePermissions((XMLStreamReader)reader, result);
                            continue block11;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private void parseDependencies(XMLStreamReader reader, FeaturePackDescription result) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case ARTIFACT: {
                            result.getDependencies().add(this.parseName(reader));
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private String parseName(XMLStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), required);
        }
        ParsingUtils.parseNoContent(reader);
        return this.propertyReplacer.replaceProperties(name);
    }

    private void parseArtifactVersions(XMLStreamReader reader, FeaturePackDescription result) throws XMLStreamException {
        Set<Artifact> artifactVersions = result.getArtifactVersions();
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case ARTIFACT: {
                            artifactVersions.add(this.parseArtifact(reader));
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private Artifact parseArtifact(XMLStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String groupId = null;
        String artifactId = null;
        String version = null;
        String classifier = null;
        String extension = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.GROUP_ID, Attribute.ARTIFACT_ID, Attribute.VERSION);
        block7: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case GROUP_ID: {
                    groupId = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block7;
                }
                case ARTIFACT_ID: {
                    artifactId = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block7;
                }
                case VERSION: {
                    version = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block7;
                }
                case CLASSIFIER: {
                    classifier = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block7;
                }
                case EXTENSION: {
                    extension = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block7;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), required);
        }
        ParsingUtils.parseNoContent(reader);
        return new Artifact(groupId, artifactId, classifier, extension, version);
    }

    private void parseConfig(XMLStreamReader reader, Config result) throws XMLStreamException {
        block8: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case STANDALONE: {
                            this.parseConfigFile(reader, result.getStandaloneConfigFiles());
                            continue block8;
                        }
                        case DOMAIN: {
                            this.parseConfigFile(reader, result.getDomainConfigFiles());
                            continue block8;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private void parseConfigFile(XMLStreamReader reader, List<ConfigFile> result) throws XMLStreamException {
        HashMap<String, String> properties = new HashMap<String, String>();
        String template = null;
        String subsystems = null;
        String outputFile = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.TEMPLATE, Attribute.SUBSYSTEMS, Attribute.OUTPUT_FILE);
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case TEMPLATE: {
                    template = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block12;
                }
                case SUBSYSTEMS: {
                    subsystems = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block12;
                }
                case OUTPUT_FILE: {
                    outputFile = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block12;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), required);
        }
        ConfigFile configFile = new ConfigFile(properties, template, subsystems, outputFile);
        result.add(configFile);
        block13: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PROPERTY: {
                            this.parseProperty(reader, properties);
                            continue block13;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private void parseProperty(XMLStreamReader reader, Map<String, String> result) throws XMLStreamException {
        String name = null;
        String value = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.VALUE);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block4;
                }
                case VALUE: {
                    value = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), required);
        }
        ParsingUtils.parseNoContent(reader);
        result.put(name, value);
    }

    private void parseCopyArtifacts(XMLStreamReader reader, FeaturePackDescription result) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case COPY_ARTIFACT: {
                            this.parseCopyArtifact(reader, result);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private void parseCopyArtifact(XMLStreamReader reader, FeaturePackDescription result) throws XMLStreamException {
        String artifact = null;
        String location = null;
        boolean extract = false;
        EnumSet<Attribute> required = EnumSet.of(Attribute.ARTIFACT, Attribute.TO_LOCATION);
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case ARTIFACT: {
                    artifact = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block12;
                }
                case TO_LOCATION: {
                    location = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block12;
                }
                case EXTRACT: {
                    extract = Boolean.parseBoolean(this.propertyReplacer.replaceProperties(reader.getAttributeValue(i)));
                    continue block12;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), required);
        }
        CopyArtifact copyArtifact = new CopyArtifact(artifact, location, extract);
        result.getCopyArtifacts().add(copyArtifact);
        block13: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case FILTER: {
                            this.parseFilter(reader, copyArtifact.getFilters());
                            continue block13;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private void parseFilter(XMLStreamReader reader, List<FileFilter> filters) throws XMLStreamException {
        String pattern = null;
        boolean include = false;
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATTERN, Attribute.INCLUDE);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PATTERN: {
                    pattern = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block4;
                }
                case INCLUDE: {
                    include = Boolean.parseBoolean(this.propertyReplacer.replaceProperties(reader.getAttributeValue(i)));
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), required);
        }
        ParsingUtils.parseNoContent(reader);
        filters.add(new FileFilter(pattern, include));
    }

    private void parseFilePermissions(XMLStreamReader reader, FeaturePackDescription result) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PERMISSION: {
                            this.parsePermission(reader, result);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private void parsePermission(XMLStreamReader reader, FeaturePackDescription result) throws XMLStreamException {
        String permission = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.VALUE);
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case VALUE: {
                    permission = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block10;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), required);
        }
        FilePermission filePermission = new FilePermission(permission);
        result.getFilePermissions().add(filePermission);
        block11: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case FILTER: {
                            this.parseFilter(reader, filePermission.getFilters());
                            continue block11;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    static enum Attribute {
        UNKNOWN(null),
        GROUP_ID("groupId"),
        ARTIFACT_ID("artifactId"),
        CLASSIFIER("classifier"),
        EXTENSION("extension"),
        VERSION("version"),
        NAME("name"),
        VALUE("value"),
        TEMPLATE("template"),
        SUBSYSTEMS("subsystems"),
        OUTPUT_FILE("output-file"),
        ARTIFACT("artifact"),
        TO_LOCATION("to-location"),
        EXTRACT("extract"),
        PATTERN("pattern"),
        INCLUDE("include");

        private static final Map<QName, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        static {
            HashMap<QName, Attribute> attributesMap = new HashMap<QName, Attribute>();
            attributesMap.put(new QName(GROUP_ID.getLocalName()), GROUP_ID);
            attributesMap.put(new QName(ARTIFACT_ID.getLocalName()), ARTIFACT_ID);
            attributesMap.put(new QName(CLASSIFIER.getLocalName()), CLASSIFIER);
            attributesMap.put(new QName(EXTENSION.getLocalName()), EXTENSION);
            attributesMap.put(new QName(VERSION.getLocalName()), VERSION);
            attributesMap.put(new QName(NAME.getLocalName()), NAME);
            attributesMap.put(new QName(TEMPLATE.getLocalName()), TEMPLATE);
            attributesMap.put(new QName(SUBSYSTEMS.getLocalName()), SUBSYSTEMS);
            attributesMap.put(new QName(OUTPUT_FILE.getLocalName()), OUTPUT_FILE);
            attributesMap.put(new QName(VALUE.getLocalName()), VALUE);
            attributesMap.put(new QName(ARTIFACT.getLocalName()), ARTIFACT);
            attributesMap.put(new QName(TO_LOCATION.getLocalName()), TO_LOCATION);
            attributesMap.put(new QName(EXTRACT.getLocalName()), EXTRACT);
            attributesMap.put(new QName(PATTERN.getLocalName()), PATTERN);
            attributesMap.put(new QName(INCLUDE.getLocalName()), INCLUDE);
            attributes = attributesMap;
        }
    }

    static enum Element {
        UNKNOWN(null),
        FEATURE_PACK("feature-pack"),
        DEPENDENCIES("dependencies"),
        ARTIFACT("artifact"),
        ARTIFACT_VERSIONS("artifact-versions"),
        CONFIG("config"),
        STANDALONE("standalone"),
        DOMAIN("domain"),
        PROPERTY("property"),
        COPY_ARTIFACTS("copy-artifacts"),
        COPY_ARTIFACT("copy-artifact"),
        FILTER("filter"),
        FILE_PERMISSIONS("file-permissions"),
        PERMISSION("permission");

        private static final Map<QName, Element> elements;
        private final String name;

        static Element of(QName qName) {
            QName name = qName.getNamespaceURI().equals("") ? new QName(FeaturePackDescriptionXMLParser10.NAMESPACE_1_0, qName.getLocalPart()) : qName;
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        static {
            HashMap<QName, Element> elementsMap = new HashMap<QName, Element>();
            elementsMap.put(new QName(FeaturePackDescriptionXMLParser10.NAMESPACE_1_0, FEATURE_PACK.getLocalName()), FEATURE_PACK);
            elementsMap.put(new QName(FeaturePackDescriptionXMLParser10.NAMESPACE_1_0, DEPENDENCIES.getLocalName()), DEPENDENCIES);
            elementsMap.put(new QName(FeaturePackDescriptionXMLParser10.NAMESPACE_1_0, ARTIFACT.getLocalName()), ARTIFACT);
            elementsMap.put(new QName(FeaturePackDescriptionXMLParser10.NAMESPACE_1_0, ARTIFACT_VERSIONS.getLocalName()), ARTIFACT_VERSIONS);
            elementsMap.put(new QName(FeaturePackDescriptionXMLParser10.NAMESPACE_1_0, CONFIG.getLocalName()), CONFIG);
            elementsMap.put(new QName(FeaturePackDescriptionXMLParser10.NAMESPACE_1_0, STANDALONE.getLocalName()), STANDALONE);
            elementsMap.put(new QName(FeaturePackDescriptionXMLParser10.NAMESPACE_1_0, DOMAIN.getLocalName()), DOMAIN);
            elementsMap.put(new QName(FeaturePackDescriptionXMLParser10.NAMESPACE_1_0, PROPERTY.getLocalName()), PROPERTY);
            elementsMap.put(new QName(FeaturePackDescriptionXMLParser10.NAMESPACE_1_0, COPY_ARTIFACTS.getLocalName()), COPY_ARTIFACTS);
            elementsMap.put(new QName(FeaturePackDescriptionXMLParser10.NAMESPACE_1_0, COPY_ARTIFACT.getLocalName()), COPY_ARTIFACT);
            elementsMap.put(new QName(FeaturePackDescriptionXMLParser10.NAMESPACE_1_0, FILTER.getLocalName()), FILTER);
            elementsMap.put(new QName(FeaturePackDescriptionXMLParser10.NAMESPACE_1_0, FILE_PERMISSIONS.getLocalName()), FILE_PERMISSIONS);
            elementsMap.put(new QName(FeaturePackDescriptionXMLParser10.NAMESPACE_1_0, PERMISSION.getLocalName()), PERMISSION);
            elements = elementsMap;
        }
    }
}

