/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.util.xml;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class FormattingXMLStreamWriter
implements XMLStreamWriter,
XMLStreamConstants {
    private static final String NO_NAMESPACE = new String();
    private final XMLStreamWriter delegate;
    private int level;
    private int state = 7;
    private boolean indentEndElement = false;
    private ArrayDeque<String> unspecifiedNamespaces = new ArrayDeque();

    public FormattingXMLStreamWriter(XMLStreamWriter delegate) {
        this.delegate = delegate;
        this.unspecifiedNamespaces.push(NO_NAMESPACE);
    }

    private void nl() throws XMLStreamException {
        this.delegate.writeCharacters("\n");
    }

    private void indent() throws XMLStreamException {
        int level = this.level;
        XMLStreamWriter delegate = this.delegate;
        for (int i = 0; i < level; ++i) {
            delegate.writeCharacters("    ");
        }
    }

    private String nestUnspecifiedNamespace() {
        ArrayDeque<String> namespaces = this.unspecifiedNamespaces;
        String clone = namespaces.getFirst();
        namespaces.push(clone);
        return clone;
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        ArrayDeque<String> namespaces = this.unspecifiedNamespaces;
        String namespace = namespaces.getFirst();
        if (namespace != NO_NAMESPACE) {
            this.writeStartElement(namespace, localName);
            return;
        }
        this.unspecifiedNamespaces.push(namespace);
        this.nl();
        this.indent();
        this.delegate.writeStartElement(localName);
        ++this.level;
        this.state = 1;
        this.indentEndElement = false;
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.nestUnspecifiedNamespace();
        this.nl();
        this.indent();
        this.delegate.writeStartElement(namespaceURI, localName);
        ++this.level;
        this.state = 1;
        this.indentEndElement = false;
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.nestUnspecifiedNamespace();
        this.nl();
        this.indent();
        this.delegate.writeStartElement(prefix, namespaceURI, localName);
        ++this.level;
        this.state = 1;
        this.indentEndElement = false;
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.nl();
        this.indent();
        this.delegate.writeEmptyElement(namespaceURI, localName);
        this.state = 2;
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.nl();
        this.indent();
        this.delegate.writeEmptyElement(prefix, namespaceURI, localName);
        this.state = 2;
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        String namespace = this.unspecifiedNamespaces.getFirst();
        if (namespace != NO_NAMESPACE) {
            this.writeEmptyElement(namespace, localName);
            return;
        }
        this.nl();
        this.indent();
        this.delegate.writeEmptyElement(localName);
        this.state = 2;
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        --this.level;
        if (this.state != 1) {
            if (this.state != 4 || this.indentEndElement) {
                this.nl();
                this.indent();
                this.indentEndElement = false;
            }
        } else {
            throw new IllegalStateException("Should not happen?");
        }
        this.delegate.writeEndElement();
        this.unspecifiedNamespaces.pop();
        this.state = 2;
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.delegate.writeEndDocument();
        this.state = 8;
    }

    @Override
    public void close() throws XMLStreamException {
        this.delegate.close();
        this.state = 8;
    }

    @Override
    public void flush() throws XMLStreamException {
        this.delegate.flush();
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.delegate.writeAttribute(localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.delegate.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.delegate.writeAttribute(namespaceURI, localName, value);
    }

    public void writeAttribute(String localName, String[] values) throws XMLStreamException {
        this.delegate.writeAttribute(localName, FormattingXMLStreamWriter.join(values));
    }

    public void writeAttribute(String prefix, String namespaceURI, String localName, String[] values) throws XMLStreamException {
        this.delegate.writeAttribute(prefix, namespaceURI, localName, FormattingXMLStreamWriter.join(values));
    }

    public void writeAttribute(String namespaceURI, String localName, String[] values) throws XMLStreamException {
        this.delegate.writeAttribute(namespaceURI, localName, FormattingXMLStreamWriter.join(values));
    }

    public void writeAttribute(String localName, Iterable<String> values) throws XMLStreamException {
        this.delegate.writeAttribute(localName, FormattingXMLStreamWriter.join(values));
    }

    public void writeAttribute(String prefix, String namespaceURI, String localName, Iterable<String> values) throws XMLStreamException {
        this.delegate.writeAttribute(prefix, namespaceURI, localName, FormattingXMLStreamWriter.join(values));
    }

    public void writeAttribute(String namespaceURI, String localName, Iterable<String> values) throws XMLStreamException {
        this.delegate.writeAttribute(namespaceURI, localName, FormattingXMLStreamWriter.join(values));
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.delegate.writeNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.delegate.writeDefaultNamespace(namespaceURI);
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        int q;
        this.nl();
        this.indent();
        StringBuilder b = new StringBuilder(data.length());
        Spliterator i = Spliterator.over(data, '\n');
        if (!i.hasNext()) {
            return;
        }
        String first = (String)i.next();
        if (!i.hasNext()) {
            this.delegate.writeComment(first);
            this.state = 5;
            return;
        }
        b.append('\n');
        for (q = 0; q < this.level; ++q) {
            b.append("    ");
        }
        b.append("  ~ ");
        b.append(first);
        do {
            b.append('\n');
            for (q = 0; q < this.level; ++q) {
                b.append("    ");
            }
            b.append("  ~ ");
            b.append((String)i.next());
        } while (i.hasNext());
        b.append('\n');
        for (q = 0; q < this.level; ++q) {
            b.append("    ");
        }
        b.append("  ");
        this.delegate.writeComment(b.toString());
        this.state = 5;
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.nl();
        this.indent();
        this.delegate.writeProcessingInstruction(target);
        this.state = 3;
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.nl();
        this.indent();
        this.delegate.writeProcessingInstruction(target, data);
        this.state = 3;
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.delegate.writeCData(data);
        this.state = 12;
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.nl();
        this.indent();
        this.delegate.writeDTD(dtd);
        this.state = 11;
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.delegate.writeEntityRef(name);
        this.state = 9;
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.delegate.writeStartDocument();
        this.nl();
        this.state = 7;
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.delegate.writeStartDocument(version);
        this.nl();
        this.state = 7;
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.delegate.writeStartDocument(encoding, version);
        this.nl();
        this.state = 7;
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        if (this.state != 4) {
            String trimmed = text.trim();
            if (trimmed.contains("\n")) {
                this.nl();
                this.indent();
            } else {
                this.delegate.writeCharacters(trimmed);
                this.indentEndElement = false;
                this.state = 4;
                return;
            }
        }
        Spliterator iterator = Spliterator.over(text, '\n');
        while (iterator.hasNext()) {
            String t = (String)iterator.next();
            this.delegate.writeCharacters(t);
            if (!iterator.hasNext()) continue;
            this.nl();
            this.indent();
        }
        this.state = 4;
        this.indentEndElement = true;
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.delegate.writeCharacters(text, start, len);
        this.state = 4;
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.delegate.getPrefix(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.delegate.setPrefix(prefix, uri);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.delegate.setDefaultNamespace(uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.delegate.setNamespaceContext(context);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.delegate.getNamespaceContext();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.delegate.getProperty(name);
    }

    private static String join(String[] values) {
        StringBuilder b = new StringBuilder();
        int valuesLength = values.length;
        for (int i = 0; i < valuesLength; ++i) {
            String s = values[i];
            if (s == null) continue;
            if (i > 0) {
                b.append(' ');
            }
            b.append(s);
        }
        return b.toString();
    }

    private static String join(Iterable<String> values) {
        StringBuilder b = new StringBuilder();
        Iterator<String> iterator = values.iterator();
        while (iterator.hasNext()) {
            String s = iterator.next();
            if (s == null) continue;
            b.append(s);
            if (!iterator.hasNext()) continue;
            b.append(' ');
        }
        return b.toString();
    }

    static final class Spliterator
    implements Iterator<String> {
        private final String subject;
        private final char delimiter;
        private int i;

        Spliterator(String subject, char delimiter) {
            this.subject = subject;
            this.delimiter = delimiter;
            this.i = 0;
        }

        static Spliterator over(String subject, char delimiter) {
            return new Spliterator(subject, delimiter);
        }

        @Override
        public boolean hasNext() {
            return this.i != -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String next() {
            String string;
            int i = this.i;
            if (i == -1) {
                throw new NoSuchElementException();
            }
            int n = this.subject.indexOf(this.delimiter, i);
            try {
                string = n == -1 ? this.subject.substring(i) : this.subject.substring(i, n);
                this.i = n == -1 ? -1 : n + 1;
            }
            catch (Throwable throwable) {
                this.i = n == -1 ? -1 : n + 1;
                throw throwable;
            }
            return string;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface ArgRunnable {
        public void run(int var1) throws XMLStreamException;
    }
}

