/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.provisioning.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.wildfly.build.ArtifactFileResolver;
import org.wildfly.build.common.model.ConfigFileOverride;
import org.wildfly.build.common.model.ConfigOverride;
import org.wildfly.build.configassembly.SubsystemConfig;
import org.wildfly.build.pack.model.FeaturePack;
import org.wildfly.build.pack.model.ModuleIdentifier;
import org.wildfly.build.provisioning.model.ModuleFilter;
import org.wildfly.build.provisioning.model.ServerProvisioningDescription;
import org.wildfly.build.util.ZipFileSubsystemInputStreamSources;

public class ServerProvisioningFeaturePack {
    private final ServerProvisioningDescription.FeaturePack description;
    private final FeaturePack featurePack;
    private final List<ConfigFile> standaloneConfigFiles;
    private final List<ConfigFile> domainConfigFiles;
    private final List<ConfigFile> hostConfigFiles;
    private final ArtifactFileResolver artifactFileResolver;

    public ServerProvisioningFeaturePack(ServerProvisioningDescription.FeaturePack description, FeaturePack featurePack, ArtifactFileResolver artifactFileResolver) throws IOException, XMLStreamException {
        this.description = description;
        this.featurePack = featurePack;
        this.artifactFileResolver = artifactFileResolver;
        ConfigOverride configOverride = ServerProvisioningFeaturePack.getConfigOverride(featurePack, description, artifactFileResolver);
        this.standaloneConfigFiles = ServerProvisioningFeaturePack.createStandaloneConfigFiles(featurePack, configOverride);
        this.domainConfigFiles = ServerProvisioningFeaturePack.createDomainConfigFiles(featurePack, configOverride);
        this.hostConfigFiles = ServerProvisioningFeaturePack.createHostConfigFiles(featurePack, configOverride);
    }

    public ServerProvisioningDescription.FeaturePack getDescription() {
        return this.description;
    }

    public FeaturePack getFeaturePack() {
        return this.featurePack;
    }

    public Map<ModuleIdentifier, FeaturePack.Module> getModules(ArtifactFileResolver artifactFileResolver) throws IOException, XMLStreamException {
        ServerProvisioningDescription.FeaturePack.ModuleFilters moduleFilters = this.description.getModuleFilters();
        HashMap<ModuleIdentifier, FeaturePack.Module> includedModules = new HashMap<ModuleIdentifier, FeaturePack.Module>();
        if (moduleFilters == null) {
            HashSet<String> subsystems = null;
            if (this.description.getConfigOverride() != null || this.description.getSubsystems() != null) {
                subsystems = new HashSet<String>();
                for (ConfigFile configFile : this.getStandaloneConfigFiles()) {
                    for (Map<String, SubsystemConfig> subsystemConfigMap : configFile.getSubsystems().values()) {
                        for (String subsystem : subsystemConfigMap.keySet()) {
                            subsystems.add(subsystem);
                        }
                    }
                }
                for (ConfigFile configFile : this.getDomainConfigFiles()) {
                    for (Map<String, SubsystemConfig> subsystemConfigMap : configFile.getSubsystems().values()) {
                        for (String subsystem : subsystemConfigMap.keySet()) {
                            subsystems.add(subsystem);
                        }
                    }
                }
                for (ConfigFile configFile : this.getHostConfigFiles()) {
                    for (Map<String, SubsystemConfig> subsystemConfigMap : configFile.getSubsystems().values()) {
                        for (String subsystem : subsystemConfigMap.keySet()) {
                            subsystems.add(subsystem);
                        }
                    }
                }
            }
            if (subsystems == null) {
                includedModules.putAll(this.featurePack.getFeaturePackAndDependenciesModules());
            } else {
                for (String subsystem : subsystems) {
                    FeaturePack.Module module = this.featurePack.getSubsystemModule(subsystem, artifactFileResolver);
                    if (module == null) {
                        throw new RuntimeException("Subsystem " + subsystem + " module not found in feature pack " + this.featurePack.getFeaturePackFile() + " and dependencies");
                    }
                    includedModules.put(module.getModuleParseResult().getIdentifier(), module);
                    includedModules.putAll(module.getDependencies());
                }
            }
        } else {
            for (FeaturePack.Module module : this.featurePack.getFeaturePackModules().values()) {
                boolean include = moduleFilters.isInclude();
                boolean transitive = true;
                for (ModuleFilter moduleFilter : moduleFilters.getFilters()) {
                    String moduleFile;
                    if (!moduleFilter.matches(moduleFile = module.getModuleFile().substring("modules".length() + 1))) continue;
                    if (moduleFilter.isInclude()) {
                        if (moduleFilter.isTransitive()) break;
                        transitive = false;
                        break;
                    }
                    include = false;
                    break;
                }
                if (!include) continue;
                includedModules.put(module.getIdentifier(), module);
                if (!transitive) continue;
                includedModules.putAll(module.getDependencies());
            }
        }
        return includedModules;
    }

    public List<ConfigFile> getDomainConfigFiles() {
        return this.domainConfigFiles;
    }

    public List<ConfigFile> getStandaloneConfigFiles() {
        return this.standaloneConfigFiles;
    }

    public List<ConfigFile> getHostConfigFiles() {
        return this.hostConfigFiles;
    }

    private static ConfigOverride getConfigOverride(FeaturePack featurePack, ServerProvisioningDescription.FeaturePack featurePackProvisioningDescription, ArtifactFileResolver artifactFileResolver) throws IOException, XMLStreamException {
        List<ServerProvisioningDescription.FeaturePack.Subsystem> subsystems;
        ConfigOverride configOverride = featurePackProvisioningDescription.getConfigOverride();
        if (configOverride == null && (subsystems = featurePackProvisioningDescription.getSubsystems()) != null) {
            configOverride = new ConfigOverride();
            ZipFileSubsystemInputStreamSources subsystemInputStreamSources = new ZipFileSubsystemInputStreamSources();
            for (ServerProvisioningDescription.FeaturePack.Subsystem subsystem : subsystems) {
                String subsystemName = subsystem.getName().endsWith(".xml") ? subsystem.getName() : subsystem.getName() + ".xml";
                FeaturePack.Module module = featurePack.getSubsystemModule(subsystemName, artifactFileResolver);
                if (module == null) {
                    throw new RuntimeException("Subsystem " + subsystemName + " module not found in feature pack " + featurePack.getFeaturePackFile() + " and dependencies");
                }
                if (subsystem.isTransitive()) {
                    subsystemInputStreamSources.addAllSubsystemFileSourcesFromModule(module, artifactFileResolver, true);
                    continue;
                }
                subsystemInputStreamSources.addSubsystemFileSourceFromModule(subsystemName, module, artifactFileResolver);
            }
            ServerProvisioningFeaturePack.createConfigFileOverridesFromSubsystems(featurePack.getFeaturePackFile(), featurePack.getDescription().getConfig().getStandaloneConfigFiles(), subsystemInputStreamSources, configOverride.getStandaloneConfigFiles());
            ServerProvisioningFeaturePack.createConfigFileOverridesFromSubsystems(featurePack.getFeaturePackFile(), featurePack.getDescription().getConfig().getDomainConfigFiles(), subsystemInputStreamSources, configOverride.getDomainConfigFiles());
            ServerProvisioningFeaturePack.createConfigFileOverridesFromSubsystems(featurePack.getFeaturePackFile(), featurePack.getDescription().getConfig().getHostConfigFiles(), subsystemInputStreamSources, configOverride.getHostConfigFiles());
        }
        return configOverride;
    }

    private static void createConfigFileOverridesFromSubsystems(File featurePackFile, List<org.wildfly.build.common.model.ConfigFile> configFiles, ZipFileSubsystemInputStreamSources subsystemInputStreamSources, Map<String, ConfigFileOverride> configFileOverrides) throws IOException, XMLStreamException {
        for (org.wildfly.build.common.model.ConfigFile configFile : configFiles) {
            Map<String, Map<String, SubsystemConfig>> subsystems = configFile.getSubsystemConfigs(featurePackFile);
            Iterator<Map<String, SubsystemConfig>> subsystemsIterator = subsystems.values().iterator();
            while (subsystemsIterator.hasNext()) {
                Map<String, SubsystemConfig> subsystemConfigs = subsystemsIterator.next();
                Iterator<String> subsystemConfigsIterator = subsystemConfigs.keySet().iterator();
                while (subsystemConfigsIterator.hasNext()) {
                    String subsystemConfig = subsystemConfigsIterator.next();
                    if (subsystemInputStreamSources.getInputStreamSource(subsystemConfig) != null) continue;
                    subsystemConfigsIterator.remove();
                }
                if (!subsystemConfigs.isEmpty()) continue;
                subsystemsIterator.remove();
            }
            if (subsystems.isEmpty()) continue;
            configFileOverrides.put(configFile.getOutputFile(), new ConfigFileOverride(configFile.getProperties(), false, subsystems, configFile.getOutputFile()));
        }
    }

    private static List<ConfigFile> createStandaloneConfigFiles(FeaturePack featurePack, ConfigOverride configOverride) {
        List<org.wildfly.build.common.model.ConfigFile> configFiles = featurePack.getDescription().getConfig().getStandaloneConfigFiles();
        Map<String, ConfigFileOverride> configFileOverrides = configOverride != null ? configOverride.getStandaloneConfigFiles() : null;
        return ServerProvisioningFeaturePack.createConfigFiles(featurePack.getFeaturePackFile(), configFiles, configOverride, configFileOverrides);
    }

    private static List<ConfigFile> createHostConfigFiles(FeaturePack featurePack, ConfigOverride configOverride) {
        List<org.wildfly.build.common.model.ConfigFile> configFiles = featurePack.getDescription().getConfig().getHostConfigFiles();
        Map<String, ConfigFileOverride> configFileOverrides = configOverride != null ? configOverride.getHostConfigFiles() : null;
        return ServerProvisioningFeaturePack.createConfigFiles(featurePack.getFeaturePackFile(), configFiles, configOverride, configFileOverrides);
    }

    private static List<ConfigFile> createDomainConfigFiles(FeaturePack featurePack, ConfigOverride configOverride) {
        List<org.wildfly.build.common.model.ConfigFile> configFiles = featurePack.getDescription().getConfig().getDomainConfigFiles();
        Map<String, ConfigFileOverride> configFileOverrides = configOverride != null ? configOverride.getDomainConfigFiles() : null;
        return ServerProvisioningFeaturePack.createConfigFiles(featurePack.getFeaturePackFile(), configFiles, configOverride, configFileOverrides);
    }

    private static List<ConfigFile> createConfigFiles(File featurePackFile, List<org.wildfly.build.common.model.ConfigFile> configFiles, ConfigOverride configOverride, Map<String, ConfigFileOverride> configFileOverrides) {
        ArrayList<ConfigFile> result;
        block3: {
            block2: {
                result = new ArrayList<ConfigFile>();
                if (configOverride == null) break block2;
                if (configFileOverrides == null || configFileOverrides.isEmpty()) break block3;
                for (org.wildfly.build.common.model.ConfigFile featurePackConfigFile : configFiles) {
                    ConfigFileOverride configFileOverride = configFileOverrides.get(featurePackConfigFile.getOutputFile());
                    if (configFileOverride == null) continue;
                    result.add(new ConfigFile(featurePackFile, featurePackConfigFile, configFileOverride));
                }
                break block3;
            }
            for (org.wildfly.build.common.model.ConfigFile featurePackConfigFile : configFiles) {
                result.add(new ConfigFile(featurePackFile, featurePackConfigFile, null));
            }
        }
        return result;
    }

    public static class ConfigFile {
        private final File featurePackFile;
        private final org.wildfly.build.common.model.ConfigFile featurePackConfigFile;
        private final ConfigFileOverride configFileOverride;
        private Map<String, Map<String, SubsystemConfig>> subsystems;

        public synchronized Map<String, Map<String, SubsystemConfig>> getSubsystems() throws IOException, XMLStreamException {
            if (this.subsystems == null) {
                this.subsystems = this.configFileOverride == null || this.configFileOverride.getSubsystems() == null ? this.featurePackConfigFile.getSubsystemConfigs(this.featurePackFile) : this.configFileOverride.getSubsystems();
            }
            return this.subsystems;
        }

        public ConfigFile(File featurePackFile, org.wildfly.build.common.model.ConfigFile featurePackConfigFile, ConfigFileOverride configFileOverride) {
            this.featurePackFile = featurePackFile;
            this.featurePackConfigFile = featurePackConfigFile;
            this.configFileOverride = configFileOverride;
        }

        public org.wildfly.build.common.model.ConfigFile getFeaturePackConfigFile() {
            return this.featurePackConfigFile;
        }

        public ConfigFileOverride getConfigFileOverride() {
            return this.configFileOverride;
        }
    }
}

