/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.provisioning;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLStreamException;
import org.jboss.logging.Logger;
import org.wildfly.build.ArtifactFileResolver;
import org.wildfly.build.ArtifactResolver;
import org.wildfly.build.common.model.ConfigFile;
import org.wildfly.build.common.model.ConfigFileOverride;
import org.wildfly.build.common.model.CopyArtifact;
import org.wildfly.build.common.model.FileFilter;
import org.wildfly.build.common.model.FilePermission;
import org.wildfly.build.configassembly.ConfigurationAssembler;
import org.wildfly.build.configassembly.SubsystemConfig;
import org.wildfly.build.pack.model.Artifact;
import org.wildfly.build.pack.model.FeaturePack;
import org.wildfly.build.pack.model.FeaturePackFactory;
import org.wildfly.build.pack.model.ModuleIdentifier;
import org.wildfly.build.provisioning.JandexIndexer;
import org.wildfly.build.provisioning.model.ServerProvisioning;
import org.wildfly.build.provisioning.model.ServerProvisioningDescription;
import org.wildfly.build.provisioning.model.ServerProvisioningFeaturePack;
import org.wildfly.build.util.BuildPropertyReplacer;
import org.wildfly.build.util.FileUtils;
import org.wildfly.build.util.ModuleArtifactPropertyResolver;
import org.wildfly.build.util.ModuleParseResult;
import org.wildfly.build.util.ZipEntryInputStreamSource;

public class ServerProvisioner {
    private static final Logger logger = Logger.getLogger(ServerProvisioner.class);
    private static final String SUBSYSTEM_SCHEMA_TARGET_DIRECTORY = "docs" + File.separator + "schema";
    private static final boolean OS_WINDOWS = System.getProperty("os.name").contains("indows");
    private final ServerProvisioningDescription description;
    private final File outputDirectory;
    private final ArtifactFileResolver artifactFileResolver;
    private final ArtifactResolver versionOverrideArtifactResolver;

    public ServerProvisioner(ServerProvisioningDescription description, File outputDirectory, ArtifactFileResolver artifactFileResolver, ArtifactResolver versionOverrideArtifactResolver) {
        this.description = description;
        this.outputDirectory = outputDirectory;
        this.artifactFileResolver = artifactFileResolver;
        this.versionOverrideArtifactResolver = versionOverrideArtifactResolver;
    }

    public void build() {
        ServerProvisioning serverProvisioning = new ServerProvisioning(this.description);
        ArrayList errors = new ArrayList();
        try {
            File schemaOutputDirectory;
            for (ServerProvisioningDescription.FeaturePack serverProvisioningFeaturePackDescription : this.description.getFeaturePacks()) {
                FeaturePack featurePack = FeaturePackFactory.createPack(serverProvisioningFeaturePackDescription.getArtifact(), this.artifactFileResolver, this.versionOverrideArtifactResolver);
                serverProvisioning.getFeaturePacks().add(new ServerProvisioningFeaturePack(serverProvisioningFeaturePackDescription, featurePack, this.artifactFileResolver));
            }
            FileUtils.deleteRecursive(this.outputDirectory);
            this.outputDirectory.mkdirs();
            if (this.description.isExtractSchemas()) {
                schemaOutputDirectory = new File(this.outputDirectory, SUBSYSTEM_SCHEMA_TARGET_DIRECTORY);
                if (!schemaOutputDirectory.exists()) {
                    schemaOutputDirectory.mkdirs();
                }
            } else {
                schemaOutputDirectory = null;
            }
            HashSet<String> filesProcessed = new HashSet<String>();
            this.processCopyArtifacts(serverProvisioning.getDescription().getCopyArtifacts(), this.versionOverrideArtifactResolver, this.outputDirectory, filesProcessed, this.artifactFileResolver, schemaOutputDirectory);
            this.processModules(serverProvisioning, this.outputDirectory, filesProcessed, this.artifactFileResolver, schemaOutputDirectory);
            this.processConfig(serverProvisioning, this.outputDirectory, filesProcessed);
            for (ServerProvisioningFeaturePack provisioningFeaturePack : serverProvisioning.getFeaturePacks()) {
                this.processFeaturePackCopyArtifacts(provisioningFeaturePack.getFeaturePack(), this.outputDirectory, filesProcessed, this.artifactFileResolver, schemaOutputDirectory);
                this.processProvisioningFeaturePackContents(provisioningFeaturePack, this.outputDirectory, filesProcessed);
                this.processFeaturePackFilePermissions(provisioningFeaturePack.getFeaturePack(), this.outputDirectory);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            if (!errors.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Some errors were encountered creating the feature pack\n");
                for (String error : errors) {
                    sb.append(error);
                    sb.append("\n");
                }
                throw new RuntimeException(sb.toString());
            }
        }
    }

    public static void build(ServerProvisioningDescription description, File outputDirectory, ArtifactFileResolver artifactFileResolver, ArtifactResolver versionOverrideArtifactResolver) {
        ServerProvisioner provisioner = new ServerProvisioner(description, outputDirectory, artifactFileResolver, versionOverrideArtifactResolver);
        provisioner.build();
    }

    private void processCopyArtifacts(List<CopyArtifact> copyArtifacts, ArtifactResolver artifactResolver, File outputDirectory, Set<String> filesProcessed, ArtifactFileResolver artifactFileResolver, File schemaOutputDirectory) throws IOException {
        for (CopyArtifact copyArtifact : copyArtifacts) {
            Artifact artifact = artifactResolver.getArtifact(copyArtifact.getArtifact());
            if (artifact == null) {
                throw new RuntimeException("Could not resolve artifact " + copyArtifact.getArtifact() + " to copy");
            }
            File artifactFile = artifactFileResolver.getArtifactFile(artifact);
            if (artifactFile == null) {
                throw new RuntimeException("Could not resolve file for artifact " + copyArtifact.getArtifact() + " to copy");
            }
            String location = copyArtifact.getToLocation();
            if (location.endsWith("/")) {
                location = location + artifactFile.getName();
            }
            if (!filesProcessed.add(location)) continue;
            File target = new File(outputDirectory, location);
            if (!target.getParentFile().isDirectory() && !target.getParentFile().mkdirs()) {
                throw new IOException("Could not create directory " + target.getParentFile());
            }
            if (copyArtifact.isExtract()) {
                this.extractArtifact(artifactFile, target, copyArtifact);
            } else {
                FileUtils.copyFile(artifactFile, target);
            }
            this.extractSchema(schemaOutputDirectory, artifact, artifactFile);
        }
    }

    private void extractSchema(File schemaOutputDirectory, Artifact artifact, File artifactFile) throws IOException {
        if (this.description.isExtractSchemas() && schemaOutputDirectory != null) {
            String groupId = artifact.getGACE().getGroupId();
            if (this.description.getExtractSchemasGroups().contains(groupId)) {
                logger.debugf("extracting schemas for artifact: '%s'", (Object)artifact);
                FileUtils.extractSchemas(artifactFile, schemaOutputDirectory);
            }
        }
    }

    private void processModules(ServerProvisioning serverProvisioning, File outputDirectory, Set<String> filesProcessed, ArtifactFileResolver artifactFileResolver, File schemaOutputDirectory) throws IOException, XMLStreamException {
        HashMap<FeaturePack, ArrayList<FeaturePack.Module>> featurePackModulesMap = new HashMap<FeaturePack, ArrayList<FeaturePack.Module>>();
        HashSet<ModuleIdentifier> moduleIdentifiers = new HashSet<ModuleIdentifier>();
        for (ServerProvisioningFeaturePack serverProvisioningFeaturePack : serverProvisioning.getFeaturePacks()) {
            ServerProvisioner.getLog().debugf("Gathering modules for provisioning feature pack %s", (Object)serverProvisioningFeaturePack.getFeaturePack().getFeaturePackFile());
            for (FeaturePack.Module module : serverProvisioningFeaturePack.getModules(artifactFileResolver).values()) {
                ModuleIdentifier moduleIdentifier = module.getIdentifier();
                if (moduleIdentifiers.add(moduleIdentifier)) {
                    ServerProvisioner.getLog().debugf("Adding module %s from feature pack %s", (Object)moduleIdentifier, (Object)module.getFeaturePack().getFeaturePackFile());
                    ArrayList<FeaturePack.Module> featurePackModules = (ArrayList<FeaturePack.Module>)featurePackModulesMap.get(module.getFeaturePack());
                    if (featurePackModules == null) {
                        featurePackModules = new ArrayList<FeaturePack.Module>();
                        featurePackModulesMap.put(module.getFeaturePack(), featurePackModules);
                    }
                    featurePackModules.add(module);
                    continue;
                }
                ServerProvisioner.getLog().debugf("Skipping %s from feature pack %s. A module with such identifier is already in the provisioning module set.", (Object)moduleIdentifier, (Object)module.getFeaturePack().getFeaturePackFile());
            }
        }
        for (Map.Entry entry : featurePackModulesMap.entrySet()) {
            FeaturePack featurePack = (FeaturePack)entry.getKey();
            List includedModules = (List)entry.getValue();
            this.processFeaturePackModules(featurePack, includedModules, serverProvisioning, outputDirectory, filesProcessed, artifactFileResolver, schemaOutputDirectory);
        }
    }

    private void processFeaturePackModules(FeaturePack featurePack, List<FeaturePack.Module> includedModules, ServerProvisioning serverProvisioning, File outputDirectory, Set<String> filesProcessed, ArtifactFileResolver artifactFileResolver, File schemaOutputDirectory) throws IOException {
        boolean thinServer = !serverProvisioning.getDescription().isCopyModuleArtifacts();
        BuildPropertyReplacer buildPropertyReplacer = thinServer ? new BuildPropertyReplacer(new ModuleArtifactPropertyResolver(featurePack.getArtifactResolver())) : null;
        try (JarFile jar = new JarFile(featurePack.getFeaturePackFile());){
            for (FeaturePack.Module module : includedModules) {
                String jarEntryName = module.getModuleFile();
                filesProcessed.add(jarEntryName);
                File targetFile = new File(outputDirectory, jarEntryName);
                targetFile.getParentFile().mkdirs();
                FileUtils.extractFile(jar, jarEntryName, targetFile);
                String moduleXmlContents = FileUtils.readFile(targetFile);
                ModuleParseResult result = module.getModuleParseResult();
                for (ModuleParseResult.ArtifactName artifactName : result.getArtifacts()) {
                    Artifact artifact;
                    String artifactCoords = artifactName.getArtifactCoords();
                    String options = artifactName.getOptions();
                    boolean jandex = false;
                    if (options != null) {
                        jandex = options.contains("jandex");
                        moduleXmlContents = moduleXmlContents.replace(artifactName.toString(), artifactCoords);
                    }
                    if ((artifact = featurePack.getArtifactResolver().getArtifact(artifactCoords)) == null) {
                        throw new RuntimeException("Could not resolve module resource artifact " + artifactName + " for feature pack " + featurePack.getFeaturePackFile());
                    }
                    try {
                        File artifactFile = artifactFileResolver.getArtifactFile(artifact);
                        serverProvisioning.getConfig().getInputStreamSources().addAllSubsystemFileSourcesFromZipFile(artifactFile);
                        this.extractSchema(schemaOutputDirectory, artifact, artifactFile);
                        if (jandex) {
                            String baseName = artifactFile.getName().substring(0, artifactFile.getName().lastIndexOf("."));
                            String extension = artifactFile.getName().substring(artifactFile.getName().lastIndexOf("."));
                            File target = new File(targetFile.getParent(), baseName + "-jandex" + extension);
                            JandexIndexer.createIndex(artifactFile, new FileOutputStream(target));
                            moduleXmlContents = moduleXmlContents.replaceAll("(\\s*)<artifact\\s+name=\"\\$\\{" + artifactCoords + "\\}\"\\s*/>", "$1<artifact name=\"\\${" + artifactCoords + "}\" />$1<resource-root path=\"" + target.getName() + "\"/>");
                        }
                        if (thinServer) continue;
                        String artifactFileName = artifactFile.getName();
                        FileUtils.copyFile(artifactFile, new File(targetFile.getParent(), artifactFileName));
                        moduleXmlContents = moduleXmlContents.replaceAll("<artifact\\s+name=\"\\$\\{" + artifactCoords + "\\}\"\\s*/>", "<resource-root path=\"" + artifactFileName + "\"/>");
                    }
                    catch (Throwable t) {
                        throw new RuntimeException("Could not extract resources from " + artifactName, t);
                    }
                }
                if (thinServer) {
                    moduleXmlContents = buildPropertyReplacer.replaceProperties(moduleXmlContents);
                }
                FileUtils.copyFile(new ByteArrayInputStream(moduleXmlContents.getBytes("UTF-8")), targetFile);
                for (String moduleDirFile : module.getModuleDirFiles()) {
                    filesProcessed.add(moduleDirFile);
                    FileUtils.extractFile(jar, moduleDirFile, new File(outputDirectory, moduleDirFile));
                }
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to process feature pack " + featurePack.getFeaturePackFile() + " modules", e);
        }
    }

    private void processConfig(ServerProvisioning serverProvisioning, File outputDirectory, Set<String> filesProcessed) throws IOException, XMLStreamException {
        ServerProvisioning.Config provisioningConfig = serverProvisioning.getConfig();
        for (ServerProvisioningFeaturePack provisioningFeaturePack : serverProvisioning.getFeaturePacks()) {
            this.processFeaturePackConfig(provisioningFeaturePack, provisioningConfig);
        }
        for (ServerProvisioning.ConfigFile provisioningConfigFile : provisioningConfig.getDomainConfigFiles().values()) {
            if (provisioningConfigFile.getTemplateInputStreamSource() == null) {
                ServerProvisioner.getLog().debugf("Skipping assembly of config file %s, template not set.", (Object)provisioningConfigFile.getOutputFile());
                continue;
            }
            ServerProvisioner.getLog().debugf("Assembling config file %s", (Object)provisioningConfigFile.getOutputFile());
            filesProcessed.add(provisioningConfigFile.getOutputFile());
            new ConfigurationAssembler(provisioningConfig.getInputStreamSources(), provisioningConfigFile.getTemplateInputStreamSource(), "domain", provisioningConfigFile.getSubsystems(), new File(outputDirectory, provisioningConfigFile.getOutputFile())).assemble();
        }
        for (ServerProvisioning.ConfigFile provisioningConfigFile : provisioningConfig.getStandaloneConfigFiles().values()) {
            if (provisioningConfigFile.getTemplateInputStreamSource() == null) {
                ServerProvisioner.getLog().debugf("Skipping assembly of config file %s, template not set.", (Object)provisioningConfigFile.getOutputFile());
                continue;
            }
            ServerProvisioner.getLog().debugf("Assembling config file %s", (Object)provisioningConfigFile.getOutputFile());
            filesProcessed.add(provisioningConfigFile.getOutputFile());
            new ConfigurationAssembler(provisioningConfig.getInputStreamSources(), provisioningConfigFile.getTemplateInputStreamSource(), "server", provisioningConfigFile.getSubsystems(), new File(outputDirectory, provisioningConfigFile.getOutputFile())).assemble();
        }
        for (ServerProvisioning.ConfigFile provisioningConfigFile : provisioningConfig.getHostConfigFiles().values()) {
            if (provisioningConfigFile.getTemplateInputStreamSource() == null) {
                ServerProvisioner.getLog().debugf("Skipping assembly of config file %s, template not set.", (Object)provisioningConfigFile.getOutputFile());
                continue;
            }
            ServerProvisioner.getLog().debugf("Assembling config file %s", (Object)provisioningConfigFile.getOutputFile());
            filesProcessed.add(provisioningConfigFile.getOutputFile());
            new ConfigurationAssembler(provisioningConfig.getInputStreamSources(), provisioningConfigFile.getTemplateInputStreamSource(), "host", provisioningConfigFile.getSubsystems(), new File(outputDirectory, provisioningConfigFile.getOutputFile())).assemble();
        }
    }

    private void processFeaturePackConfig(ServerProvisioningFeaturePack provisioningFeaturePack, ServerProvisioning.Config provisioningConfig) throws IOException, XMLStreamException {
        FeaturePack featurePack = provisioningFeaturePack.getFeaturePack();
        ServerProvisioner.getLog().debug((Object)("Processing provisioning feature pack " + featurePack.getFeaturePackFile() + " configs"));
        try (ZipFile zipFile = new ZipFile(featurePack.getFeaturePackFile());){
            for (ServerProvisioningFeaturePack.ConfigFile serverProvisioningFeaturePackConfigFile : provisioningFeaturePack.getDomainConfigFiles()) {
                this.processFeaturePackConfigFile(serverProvisioningFeaturePackConfigFile, zipFile, provisioningFeaturePack, provisioningConfig.getDomainConfigFiles());
            }
            for (ServerProvisioningFeaturePack.ConfigFile serverProvisioningFeaturePackConfigFile : provisioningFeaturePack.getStandaloneConfigFiles()) {
                this.processFeaturePackConfigFile(serverProvisioningFeaturePackConfigFile, zipFile, provisioningFeaturePack, provisioningConfig.getStandaloneConfigFiles());
            }
            for (ServerProvisioningFeaturePack.ConfigFile serverProvisioningFeaturePackConfigFile : provisioningFeaturePack.getHostConfigFiles()) {
                this.processFeaturePackConfigFile(serverProvisioningFeaturePackConfigFile, zipFile, provisioningFeaturePack, provisioningConfig.getHostConfigFiles());
            }
        }
    }

    private void processFeaturePackConfigFile(ServerProvisioningFeaturePack.ConfigFile serverProvisioningFeaturePackConfigFile, ZipFile zipFile, ServerProvisioningFeaturePack provisioningFeaturePack, Map<String, ServerProvisioning.ConfigFile> provisioningConfigFiles) throws IOException, XMLStreamException {
        ConfigFileOverride configFileOverride;
        ConfigFile configFile = serverProvisioningFeaturePackConfigFile.getFeaturePackConfigFile();
        ServerProvisioning.ConfigFile provisioningConfigFile = provisioningConfigFiles.get(configFile.getOutputFile());
        if (provisioningConfigFile == null) {
            provisioningConfigFile = new ServerProvisioning.ConfigFile(configFile.getOutputFile());
            provisioningConfigFiles.put(configFile.getOutputFile(), provisioningConfigFile);
        }
        if ((configFileOverride = serverProvisioningFeaturePackConfigFile.getConfigFileOverride()) == null || configFileOverride.isUseTemplate()) {
            ZipEntry templateFileZipEntry = zipFile.getEntry(configFile.getTemplate());
            if (templateFileZipEntry == null) {
                throw new RuntimeException("Feature pack " + provisioningFeaturePack.getFeaturePack().getFeaturePackFile() + " template file " + configFile.getTemplate() + " not found");
            }
            provisioningConfigFile.setTemplateInputStreamSource(new ZipEntryInputStreamSource(provisioningFeaturePack.getFeaturePack().getFeaturePackFile(), templateFileZipEntry));
        }
        Map<String, Map<String, SubsystemConfig>> subsystems = serverProvisioningFeaturePackConfigFile.getSubsystems();
        for (Map.Entry<String, Map<String, SubsystemConfig>> subsystemsEntry : subsystems.entrySet()) {
            String profileName = subsystemsEntry.getKey();
            Map<String, SubsystemConfig> subsystemConfigMap = subsystemsEntry.getValue();
            Map<String, SubsystemConfig> provisioningSubsystems = provisioningConfigFile.getSubsystems().get(profileName);
            if (provisioningSubsystems == null) {
                provisioningSubsystems = new LinkedHashMap<String, SubsystemConfig>();
                provisioningConfigFile.getSubsystems().put(profileName, provisioningSubsystems);
            }
            for (Map.Entry<String, SubsystemConfig> subsystemConfigMapEntry : subsystemConfigMap.entrySet()) {
                String subsystemFile = subsystemConfigMapEntry.getKey();
                SubsystemConfig subsystemConfig = subsystemConfigMapEntry.getValue();
                ServerProvisioner.getLog().debugf("Adding subsystem config %s to provisioning config file %s", (Object)subsystemFile, (Object)provisioningConfigFile.getOutputFile());
                provisioningSubsystems.put(subsystemFile, subsystemConfig);
            }
        }
    }

    private void processFeaturePackCopyArtifacts(FeaturePack featurePack, File outputDirectory, Set<String> filesProcessed, ArtifactFileResolver artifactFileResolver, File schemaOutputDirectory) throws IOException {
        this.processCopyArtifacts(featurePack.getDescription().getCopyArtifacts(), featurePack.getArtifactResolver(), outputDirectory, filesProcessed, artifactFileResolver, schemaOutputDirectory);
        for (FeaturePack dependency : featurePack.getDependencies()) {
            this.processFeaturePackCopyArtifacts(dependency, outputDirectory, filesProcessed, artifactFileResolver, schemaOutputDirectory);
        }
    }

    private void processProvisioningFeaturePackContents(ServerProvisioningFeaturePack provisioningFeaturePack, File outputDirectory, Set<String> filesProcessed) throws IOException {
        if (provisioningFeaturePack.getDescription().includesContentFiles()) {
            this.processFeaturePackContents(provisioningFeaturePack.getFeaturePack(), provisioningFeaturePack.getDescription().getContentFilters(), outputDirectory, filesProcessed);
        }
    }

    private void processFeaturePackContents(FeaturePack featurePack, ServerProvisioningDescription.FeaturePack.ContentFilters contentFilters, File outputDirectory, Set<String> filesProcessed) throws IOException {
        int fileNameWithoutContentsStart = "content".length() + 1;
        try (JarFile jar = new JarFile(featurePack.getFeaturePackFile());){
            for (String contentFile : featurePack.getContentFiles()) {
                String outputFile = contentFile.substring(fileNameWithoutContentsStart);
                boolean include = true;
                if (contentFilters != null) {
                    include = contentFilters.isInclude();
                    for (FileFilter contentFilter : contentFilters.getFilters()) {
                        if (!contentFilter.matches(outputFile) || contentFilter.isInclude()) continue;
                        include = false;
                        break;
                    }
                }
                if (!include) {
                    ServerProvisioner.getLog().debugf("Skipping feature pack %s filtered content file %s", (Object)featurePack.getFeaturePackFile(), (Object)outputFile);
                    continue;
                }
                if (!filesProcessed.add(outputFile)) {
                    ServerProvisioner.getLog().debugf("Skipping already processed feature pack %s content file %s", (Object)featurePack.getFeaturePackFile(), (Object)outputFile);
                    continue;
                }
                ServerProvisioner.getLog().debugf("Adding feature pack %s content file %s", (Object)featurePack.getFeaturePackFile(), (Object)outputFile);
                FileUtils.extractFile(jar, contentFile, new File(outputDirectory, outputFile));
            }
        }
        for (FeaturePack dependency : featurePack.getDependencies()) {
            this.processFeaturePackContents(dependency, contentFilters, outputDirectory, filesProcessed);
        }
    }

    private void processFeaturePackFilePermissions(FeaturePack featurePack, File outputDirectory) throws IOException {
        final Path baseDir = Paths.get(outputDirectory.getAbsolutePath(), new String[0]);
        final List<FilePermission> filePermissions = featurePack.getDescription().getFilePermissions();
        Files.walkFileTree(baseDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                String relative = baseDir.relativize(dir).toString();
                if (!OS_WINDOWS) {
                    for (FilePermission perm : filePermissions) {
                        if (!perm.includeFile(relative)) continue;
                        Files.setPosixFilePermissions(dir, perm.getPermission());
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String relative = baseDir.relativize(file).toString();
                if (!OS_WINDOWS) {
                    for (FilePermission perm : filePermissions) {
                        if (!perm.includeFile(relative)) continue;
                        Files.setPosixFilePermissions(file, perm.getPermission());
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        for (FeaturePack dependency : featurePack.getDependencies()) {
            this.processFeaturePackFilePermissions(dependency, outputDirectory);
        }
    }

    private void extractArtifact(File file, File target, CopyArtifact copy) throws IOException {
        try (ZipFile zip = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!copy.includeFile(entry.getName())) continue;
                if (entry.isDirectory()) {
                    new File(target, entry.getName()).mkdirs();
                    continue;
                }
                InputStream in = zip.getInputStream(entry);
                Throwable throwable = null;
                try {
                    FileUtils.copyFile(in, new File(target, entry.getName()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
    }

    static Logger getLog() {
        return logger;
    }
}

