/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.common.model;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLStreamException;
import org.wildfly.build.configassembly.SubsystemConfig;
import org.wildfly.build.configassembly.SubsystemsParser;
import org.wildfly.build.util.InputStreamSource;
import org.wildfly.build.util.ZipEntryInputStreamSource;

public class ConfigFile {
    private final Map<String, String> properties;
    private final String template;
    private final String subsystems;
    private final String outputFile;

    public ConfigFile(Map<String, String> properties, String template, String subsystems, String outputFile) {
        this.properties = properties;
        this.template = template;
        this.subsystems = subsystems;
        this.outputFile = outputFile;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getSubsystems() {
        return this.subsystems;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public Map<String, Map<String, SubsystemConfig>> getSubsystemConfigs(File featurePackFile) throws IOException, XMLStreamException {
        HashMap<String, Map<String, SubsystemConfig>> subsystems = new HashMap<String, Map<String, SubsystemConfig>>();
        try (ZipFile zip = new ZipFile(featurePackFile);){
            ZipEntry zipEntry = zip.getEntry(this.getSubsystems());
            if (zipEntry == null) {
                throw new RuntimeException("Feature pack " + featurePackFile + " subsystems file " + this.getSubsystems() + " not found");
            }
            ZipEntryInputStreamSource inputStreamSource = new ZipEntryInputStreamSource(featurePackFile, zipEntry);
            SubsystemsParser.parse((InputStreamSource)inputStreamSource, this.getProperties(), subsystems);
        }
        return subsystems;
    }
}

