/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.util;

import java.util.ArrayList;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Document;
import org.wildfly.build.pack.model.Artifact;
import org.wildfly.build.pack.model.ModuleIdentifier;

public class ModuleParseResult {
    final List<ModuleDependency> dependencies = new ArrayList<ModuleDependency>();
    final List<String> resourceRoots = new ArrayList<String>();
    final List<ArtifactName> artifacts = new ArrayList<ArtifactName>();
    final Document document;
    ModuleIdentifier identifier;
    ArtifactName versionArtifactName;

    public ModuleParseResult(Document document) {
        this.document = document;
    }

    public List<ModuleDependency> getDependencies() {
        return this.dependencies;
    }

    public List<String> getResourceRoots() {
        return this.resourceRoots;
    }

    public List<ArtifactName> getArtifacts() {
        return this.artifacts;
    }

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    public Document getDocument() {
        return this.document;
    }

    public ArtifactName getVersionArtifactName() {
        return this.versionArtifactName;
    }

    public static class ArtifactName {
        private final String artifactCoords;
        private final String options;
        private final Attribute attribute;

        public ArtifactName(String artifactCoords, String options, Attribute attribute) {
            this.artifactCoords = artifactCoords;
            this.options = options;
            this.attribute = attribute;
        }

        public String getArtifactCoords() {
            return this.artifactCoords;
        }

        public String getOptions() {
            return this.options;
        }

        public Attribute getAttribute() {
            return this.attribute;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.artifactCoords);
            if (this.options != null) {
                sb.append('?').append(this.options);
            }
            return sb.toString();
        }

        public boolean hasVersion() {
            String version;
            String[] parts = this.artifactCoords.split(":");
            return parts.length > 2 && (version = parts[2]) != null && !version.isEmpty();
        }

        public Artifact getArtifact() {
            if (!this.hasVersion()) {
                throw new IllegalStateException("can only be called when version is hard coded");
            }
            String[] parts = this.getArtifactCoords().split(":");
            if (parts.length == 3) {
                return new Artifact(parts[0], parts[1], null, "jar", parts[2]);
            }
            return new Artifact(parts[0], parts[1], parts[3], "jar", parts[2]);
        }
    }

    public static class ModuleDependency {
        private final ModuleIdentifier moduleId;
        private final boolean optional;

        public ModuleDependency(ModuleIdentifier moduleId, boolean optional) {
            this.moduleId = moduleId;
            this.optional = optional;
        }

        public ModuleIdentifier getModuleId() {
            return this.moduleId;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public String toString() {
            return "[" + this.moduleId + (this.optional ? ",optional=true" : "") + "]";
        }
    }
}

