/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.compatibility.subA;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.wildfly.camel.test.compatibility.subA.ServiceA1;

@Component(service={ServiceA.class}, immediate=true)
public class ServiceA {
    static AtomicInteger INSTANCE_COUNT = new AtomicInteger();
    final String name = this.getClass().getSimpleName() + "#" + INSTANCE_COUNT.incrementAndGet();
    final AtomicReference<ServiceA1> ref = new AtomicReference();
    private ComponentContext context;

    @Activate
    void activate(ComponentContext context) {
        this.context = context;
    }

    @Deactivate
    void deactivate() {
    }

    public ComponentContext getComponentContext() {
        return this.context;
    }

    @Reference
    void bindServiceA1(ServiceA1 service) {
        this.ref.set(service);
    }

    void unbindServiceA1(ServiceA1 service) {
        this.ref.compareAndSet(service, null);
    }

    public ServiceA1 getServiceA1() {
        return this.ref.get();
    }

    public String doStuff(String msg) {
        ServiceA1 srv = this.ref.get();
        return this.name + ":" + srv.doStuff(msg);
    }

    public String toString() {
        return this.name;
    }
}

