/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.jms;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.http.HttpRequest;
import org.wildfly.camel.test.common.utils.JMSUtils;

@RunAsClient
@RunWith(value=Arquillian.class)
@ServerSetup(value={JmsQueueSetup.class})
public class JMSExampleTest {
    private static String ORDERS_QUEUE = "OrdersQueue";
    private static String ORDERS_QUEUE_JNDI = "java:/jms/queue/OrdersQueue";
    private File destination = new File(System.getProperty("jboss.home") + "/standalone/data/orders");

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)new File("target/examples/example-camel-jms.war"));
    }

    @After
    public void tearDown() throws IOException {
        Files.walkFileTree(this.destination.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exception) throws IOException {
                exception.printStackTrace();
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exception) throws IOException {
                if (exception == null) {
                    Files.delete(dir);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @Test
    public void testFileToJmsRoute() throws Exception {
        InputStream input = this.getClass().getResourceAsStream("/jms/order.xml");
        Files.copy(input, this.destination.toPath().resolve("order.xml"), new CopyOption[0]);
        input.close();
        Thread.sleep(2000L);
        HttpRequest.HttpResponse result = HttpRequest.get((String)this.getEndpointAddress("/example-camel-jms/orders")).getResponse();
        Assert.assertTrue((boolean)result.getBody().contains("UK: 1"));
    }

    private String getEndpointAddress(String contextPath) throws MalformedURLException {
        return "http://localhost:8080" + contextPath;
    }

    static class JmsQueueSetup
    implements ServerSetupTask {
        JmsQueueSetup() {
        }

        public void setup(ManagementClient managementClient, String containerId) throws Exception {
            JMSUtils.createJmsQueue((String)ORDERS_QUEUE, (String)ORDERS_QUEUE_JNDI, (ModelControllerClient)managementClient.getControllerClient());
        }

        public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
            JMSUtils.removeJmsQueue((String)ORDERS_QUEUE, (ModelControllerClient)managementClient.getControllerClient());
        }
    }
}

