/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.activemq;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.dmr.ModelNode;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.FileConsumingTestSupport;
import org.wildfly.camel.test.common.http.HttpRequest;
import org.wildfly.camel.test.common.utils.DMRUtils;

@RunAsClient
@RunWith(value=Arquillian.class)
@ServerSetup(value={ActiveMQRarSetupTask.class})
public class ActiveMQExampleTest
extends FileConsumingTestSupport {
    private static final String ACTIVEMQ_EXAMPLE_WAR = "example-camel-activemq.war";
    private static final String ACTIVEMQ_RAR = "activemq-rar.rar";

    @Deployment(name="activemq-rar.rar", testable=false, order=1)
    public static ResourceAdapterArchive createRarDeployment() {
        return (ResourceAdapterArchive)ShrinkWrap.createFromZipFile(ResourceAdapterArchive.class, (File)new File("target/examples/activemq-rar.rar"));
    }

    @Deployment(name="example-camel-activemq.war", testable=false, order=2)
    public static WebArchive createDeployment() {
        return (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)new File("target/examples/example-camel-activemq.war"));
    }

    @Test
    public void testFileToActiveMQRoute() throws Exception {
        HttpRequest.HttpResponse result = HttpRequest.get((String)"http://localhost:8080/example-camel-activemq/orders").getResponse();
        Assert.assertTrue((boolean)result.getBody().contains("UK: 1"));
    }

    @Override
    protected String sourceFilename() {
        return "order.xml";
    }

    @Override
    protected Path destinationPath() {
        return Paths.get(System.getProperty("jboss.home") + "/standalone/data/orders", new String[0]);
    }

    @Override
    protected Path processedPath() {
        return this.destinationPath().resolve("processed/UK");
    }

    static class ActiveMQRarSetupTask
    implements ServerSetupTask {
        ActiveMQRarSetupTask() {
        }

        public void setup(ManagementClient managementClient, String s) throws Exception {
            ModelNode batchNode = DMRUtils.batchNode().addStep("subsystem=resource-adapters/resource-adapter=amq-ra.rar", "add(archive=activemq-rar.rar)").addStep("subsystem=resource-adapters/resource-adapter=amq-ra.rar", "write-attribute(name=transaction-support,value=NoTransaction)").addStep("subsystem=resource-adapters/resource-adapter=amq-ra.rar/connection-definitions=QueueConnectionFactory", "add(class-name=org.apache.activemq.ra.ActiveMQManagedConnectionFactory, jndi-name=java:/ActiveMQConnectionFactory)").addStep("subsystem=resource-adapters/resource-adapter=amq-ra.rar/connection-definitions=QueueConnectionFactory/config-properties=ServerUrl", "add(value=vm://localhost?broker.persistent=false&broker.useJmx=false&broker.useShutdownHook=false)").addStep("subsystem=resource-adapters/resource-adapter=amq-ra.rar/admin-objects=OrdersQueue", "add(class-name=org.apache.activemq.command.ActiveMQQueue, jndi-name=java:/OrdersQueue)").addStep("subsystem=resource-adapters/resource-adapter=amq-ra.rar/admin-objects=OrdersQueue/config-properties=PhysicalName", "add(value=OrdersQueue)").build();
            managementClient.getControllerClient().execute(batchNode);
        }

        public void tearDown(ManagementClient managementClient, String s) throws Exception {
            ModelNode batchNode = DMRUtils.batchNode().addStep("subsystem=resource-adapters/resource-adapter=amq-ra.rar", "remove").build();
            managementClient.getControllerClient().execute(batchNode);
        }
    }
}

