/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.jms;

import java.io.File;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.ServerLogReader;
import org.wildfly.camel.test.common.utils.JMSUtils;

@RunAsClient
@RunWith(value=Arquillian.class)
@ServerSetup(value={JmsQueueSetup.class})
public class JMSMDBExampleTest {
    private static String ORDERS_QUEUE = "OrdersQueue";
    private static String ORDERS_QUEUE_JNDI = "java:/jms/queue/OrdersQueue";

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)new File("target/examples/example-camel-jms-mdb.war"));
    }

    @Test
    public void testJMSMDBRoute() throws IOException {
        boolean logMessagePresent = ServerLogReader.awaitLogMessage(".*Received message: Message [0-9].*", 10000L);
        Assert.assertTrue((String)"Message 'Received message' not found in server log", (boolean)logMessagePresent);
    }

    static class JmsQueueSetup
    implements ServerSetupTask {
        JmsQueueSetup() {
        }

        public void setup(ManagementClient managementClient, String containerId) throws Exception {
            JMSUtils.createJmsQueue((String)ORDERS_QUEUE, (String)ORDERS_QUEUE_JNDI, (ModelControllerClient)managementClient.getControllerClient());
        }

        public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
            JMSUtils.removeJmsQueue((String)ORDERS_QUEUE, (ModelControllerClient)managementClient.getControllerClient());
        }
    }
}

