/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.jaxws;

import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.wildfly.camel.examples.jaxws.GreetingService;

@WebServlet(name="HttpServiceServlet", urlPatterns={"/jaxws/*"}, loadOnStartup=1)
public class JaxwsServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.getRequestDispatcher("/index.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String message = request.getParameter("message");
        String name = request.getParameter("name");
        URL wsdlLocation = new URL("http://localhost:8080/example-camel-jaxws/greeting?wsdl");
        QName serviceName = new QName("http://jaxws.examples.camel.wildfly.org/", "greeting");
        Service service = Service.create((URL)wsdlLocation, (QName)serviceName);
        GreetingService greetingService = (GreetingService)service.getPort(GreetingService.class);
        String greeting = message != null && !message.isEmpty() && name != null && !name.isEmpty() ? greetingService.greetWithMessage(message, name) : ((message == null || message.isEmpty()) && name != null && !name.isEmpty() ? greetingService.greet(name) : "Hello unknown");
        request.setAttribute("greeting", (Object)greeting);
        request.getRequestDispatcher("/greeting.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }
}

