/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.jpa;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.wildfly.camel.examples.jpa.CustomerRepository;

@WebServlet(name="HttpServiceServlet", urlPatterns={"/customers/*"}, loadOnStartup=1)
public class SimpleServlet
extends HttpServlet {
    static Path CUSTOMERS_PATH = new File(System.getProperty("jboss.server.data.dir")).toPath().resolve("customers");
    @Inject
    private CustomerRepository customerRepository;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletContext servletContext = config.getServletContext();
        try {
            InputStream input = servletContext.getResourceAsStream("/WEB-INF/customer.xml");
            Path xmlPath = CUSTOMERS_PATH.resolve("customer.xml");
            Files.copy(input, xmlPath, new CopyOption[0]);
        }
        catch (IOException ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        List customers = this.customerRepository.findAllCustomers();
        request.setAttribute("customers", (Object)customers);
        request.getRequestDispatcher("/WEB-INF/customers.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }
}

