/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.mail;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.annotation.Resource;
import javax.ejb.Startup;
import javax.enterprise.context.ApplicationScoped;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.component.mail.MailConfiguration;
import org.apache.camel.component.mail.MailEndpoint;

@Startup
@ApplicationScoped
@ContextName(value="mail-camel-context")
public class MailRouteBuilder
extends RouteBuilder {
    @Resource(mappedName="java:jboss/mail/greenmail")
    private Session mailSession;

    public void configure() throws Exception {
        MailEndpoint sendMailEndpoint = (MailEndpoint)this.getContext().getEndpoint("smtp://localhost");
        this.configureMailEndpoint(sendMailEndpoint);
        MailEndpoint receiveMailEndpoint = (MailEndpoint)this.getContext().getEndpoint("pop3://user2@localhost?consumer.delay=30000");
        this.configureMailEndpoint(receiveMailEndpoint);
        this.from("direct:sendmail").to((Endpoint)sendMailEndpoint);
        this.from((Endpoint)receiveMailEndpoint).to("log:emails?showAll=true&multiline=true");
    }

    private void configureMailEndpoint(MailEndpoint endpoint) throws UnknownHostException {
        MailConfiguration configuration = endpoint.getConfiguration();
        String protocol = configuration.getProtocol();
        String host = this.mailSession.getProperty("mail." + protocol + ".host");
        String user = this.mailSession.getProperty("mail." + protocol + ".user");
        int port = Integer.parseInt(this.mailSession.getProperty("mail." + protocol + ".port"));
        InetAddress address = InetAddress.getByName(host);
        PasswordAuthentication auth = this.mailSession.requestPasswordAuthentication(address, port, protocol, null, user);
        configuration.setPort(port);
        configuration.setUsername(auth.getUserName());
        configuration.setPassword(auth.getPassword());
    }
}

