/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.rest;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.component.bean.ProxyHelper;
import org.wildfly.camel.examples.rest.GreetingService;

@Path(value="/greet")
public class GreetingServiceImpl {
    @Inject
    @ContextName(value="system-context-1")
    private CamelContext context;
    private GreetingService greetingServiceProxy;

    @PostConstruct
    public void initServiceProxy() throws Exception {
        Endpoint endpoint = this.context.getEndpoint("direct:start");
        this.greetingServiceProxy = (GreetingService)ProxyHelper.createProxy((Endpoint)endpoint, GreetingService.class);
    }

    @GET
    @Path(value="/hello/{name}")
    @Produces(value={"application/json"})
    public Response sayHello(@PathParam(value="name") String name) {
        return this.greetingServiceProxy.sayHello(name);
    }
}

